/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Class used to export feature points to file of fp format
 * 
 * @author kubok
 */
public class FeaturePointsFpExporter {
    
        public FeaturePointsFpExporter() {
            
        }
    
        public void exportFeaturePointsToFP(List<FeaturePoint> featurePointList, String objectName) throws FileNotFoundException, IOException {
        File csvOutputFile = new File(String.format("%s_landmarks.fp", objectName));
        // CSV is a normal text file, need a writer
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(csvOutputFile))) {
            bw.write(String.format("<!--Saved by software Fidentis Analyst--><facialPoints model=\"%s\">", objectName));
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.newLine();
                    bw.write(String.format("<facialPoint type=\"%s\">", featurePoint.getFeaturePointType().getType()));
                    bw.newLine();
                    bw.write(String.format("<x>%f</x>", featurePoint.getX()));
                    bw.newLine();
                    bw.write(String.format("<y>%f</y>", featurePoint.getY()));
                    bw.newLine();
                    bw.write(String.format("<z>%f</z>", featurePoint.getZ()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointImportService.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            bw.newLine();
            bw.write("</facialPoints>");
        }

    }     
        
}
