/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.exception.FeaturePointException;
import cz.fidentis.analyst.feature.provider.FeaturePointTypeProvider;
import cz.fidentis.analyst.feature.utils.FileResourcesUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * Class used to import feature points from file of csv format
 * 
 * @author kubok
 */
public class FeaturePointsCsvLoader {
    
    private static final String COLUMN_DELIMETER = ",";
    private static final String CODE_PREFIX_DELIMETER = " ";

    public Optional<List<FeaturePoint>> importFeaturePointsCSV(String path, String fileName) {
        FileResourcesUtils app = new FileResourcesUtils();
        try (InputStreamReader streamReader
                = new InputStreamReader(app.getFileAsStream(path, fileName), StandardCharsets.UTF_8);
                BufferedReader reader = new BufferedReader(streamReader)) {

            Stream<String> lines = reader.lines();
            List<List<String>> linesList = new ArrayList<>();

            lines
                    .forEach(line -> {
                        linesList.add(Arrays.asList(line.split(COLUMN_DELIMETER)));
                    });

            if (linesList.size() != 2
                    || linesList.get(0).size() != linesList.get(1).size()) {
                throw new FeaturePointException(String.format("Feature point import file '%s' has wrong format", fileName));
            }

            List<FeaturePoint> points = new ArrayList<>();
            for (int i = 1; i < linesList.get(0).size(); i += 3) {
                FeaturePoint point = new FeaturePoint(
                        Double.parseDouble(linesList.get(1).get(i)),
                        Double.parseDouble(linesList.get(1).get(i + 1)),
                        Double.parseDouble(linesList.get(1).get(i + 2)),
                        FeaturePointTypeProvider.getInstance().getFeaturePointTypeByCode(
                                getCode(linesList.get(0).get(i)))
                );
                points.add(point);
            }
            return Optional.of(points);

        } catch (IOException e) {
            throw new FeaturePointException(String.format("Feature point cannot open file", fileName));
        } catch (NumberFormatException e1) {
            throw new FeaturePointException(e1.getMessage());
        }
    }

    private String getCode(String str) {
        return str.substring(0, str.indexOf(CODE_PREFIX_DELIMETER));
    }
}
