/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * Class used to export feature points to file of csv format
 * 
 * @author kubok
 */
public class FeaturePointsCsvExporter {
    
        public FeaturePointsCsvExporter() {
            
        }
   
        public void exportFeaturePointsToCSV(List<FeaturePoint> featurePointList, String objectName) throws IOException {
        File csvOutputFile = new File(String.format("%s_landmarks.csv", objectName));
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(csvOutputFile))) {
            bw.write("Scan name");
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.write(String.format(",%s x", featurePoint.getFeaturePointType().getCode()));
                    bw.write(String.format(",%s y", featurePoint.getFeaturePointType().getCode()));
                    bw.write(String.format(",%s z", featurePoint.getFeaturePointType().getCode()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointImportService.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            bw.newLine();
            bw.write(String.format("%s", objectName));
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getX()));
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getY()));
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getZ()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointImportService.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
    }


    
}
