/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.FeaturePointType;
import cz.fidentis.analyst.feature.utils.FeaturePointFileFormatTypes;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import cz.fidentis.analyst.feature.services.FeaturePointsCsvExporter;
import cz.fidentis.analyst.feature.services.FeaturePointsFpExporter;

/**
 * Class used for exporting feature points from file
 * 
 * for more details @see cz.fidentis.analyst.feature.services.FeaturePointsCsvExporter or @see cz.fidentis.analyst.feature.services.FeaturePointsFpExporter
 * 
 * @author kubok
 */
public class FeaturePointExportService {

    public void exportFeaturePoints(List<FeaturePoint> featurePointList, String objectName, String format) throws FileNotFoundException, IOException {
        switch (format) {
            case FeaturePointFileFormatTypes.FORMAT_TYPE_OBJ:
                FeaturePointsCsvExporter csvExporter = new FeaturePointsCsvExporter();
                csvExporter.exportFeaturePointsToCSV(featurePointList, objectName);
                break;

            case FeaturePointFileFormatTypes.FORMAT_TYPE_FP:
                FeaturePointsFpExporter fpExporter = new FeaturePointsFpExporter();
                fpExporter.exportFeaturePointsToFP(featurePointList, objectName);
                break;
                
            default:
                break;
        }
    }



}
