/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.feature.provider;

import cz.fidentis.analyst.feature.FeaturePointType;
import cz.fidentis.analyst.feature.services.FeaturePointTypesService;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author kubok
 */
public class FeaturePointTypeProvider {

    private final Map<Integer, FeaturePointType> featurePointTypesById;
    private final Map<String, FeaturePointType> featurePointTypesByCode;

    // provide thread safe singleton
    private static class InstanceHolder {

        public static FeaturePointTypeProvider instance = new FeaturePointTypeProvider();
    }

    private FeaturePointTypeProvider() {
        FeaturePointTypesService service = new FeaturePointTypesService();
        featurePointTypesById = service.readResources().orElse(new HashMap<>());
        featurePointTypesByCode = service.getFeaturepointTypesByCode(featurePointTypesById);
    }

    /**
     * Access feature point types
     *
     * @return
     */
    public static FeaturePointTypeProvider getInstance() {
        return InstanceHolder.instance;
    }

    public Map<Integer, FeaturePointType> getFeaturePointTypesById() {
        return featurePointTypesById;
    }

    public Map<String, FeaturePointType> getFeaturePointTypesByCode() {
        return featurePointTypesByCode;
    }

    /**
     * Get feature point by code
     *
     * @param code
     * @return
     */
    public FeaturePointType getFeaturePointTypeByCode(String code) {
        return getFeaturePointTypesByCode().get(code);
    }

    public FeaturePointType getFeaturePointTypeById(int id) {
        return getFeaturePointTypesById().get(id);
    }
}
