package cz.fidentis.analyst.dashboard;

import cz.fidentis.analyst.core.ControlPanelBuilder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

/**
 * Panel for showing filter options
 * 
 * @author Matej Kovar
 */
public final class FilterPanel extends JPanel {

    private final JPanel controlPanel;
    
    private boolean kdTreeFilter = false;
    private boolean featurePointsFilter = false;
    private boolean alphabeticalFilter = false;
   

    /**
     * Constructor
     * @param controlPanel control panel where components will be added
     * @param action ActionListener
     */
    public FilterPanel(JPanel controlPanel, ActionListener action) {
        
        this.controlPanel = controlPanel;
        ControlPanelBuilder builder = new ControlPanelBuilder(this.controlPanel);
        
        builder.addCaptionLine("Filter");
        builder.addLine();
        
        builder.addCheckBoxOptionLine(
                null, 
                "has KD-tree", 
                false, 
                (ActionEvent e) -> { 
                    kdTreeFilter = (((JCheckBox) e.getSource()).isSelected());
                }
        );
        builder.addLine();
        
        builder.addCheckBoxOptionLine(
                null, 
                "has feature points", 
                false, 
                (ActionEvent e) -> { 
                    featurePointsFilter = (((JCheckBox) e.getSource()).isSelected());
                }
        );
        builder.addLine();
                
        builder.addCheckBoxOptionLine(
                null, 
                "...", 
                false, 
                null
        );
        builder.addLine();
        
        builder.addCheckBoxOptionLine(
                null, 
                "...", 
                false, 
                null
        );
        builder.addLine();
        
        builder.addCheckBoxOptionLine(
                null, 
                "alphabetical", 
                false, 
                (ActionEvent e) -> { 
                    alphabeticalFilter = (((JCheckBox) e.getSource()).isSelected());
                }
        );
        builder.addLine();
        
        builder.addButton(
                "Apply filter",
                action
        );
    }

    public boolean isKdTreeFilter() {
        return kdTreeFilter;
    }

    public boolean isFeaturePointsFilter() {
        return featurePointsFilter;
    }
    
    public boolean isAlphaBeticalFilter() {
        return alphabeticalFilter;
    }
    
}
