package cz.fidentis.analyst.canvas.toolbar;

import com.jogamp.opengl.GL2;
import cz.fidentis.analyst.canvas.Canvas;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.openide.util.NbBundle;

/**
 * Canvas toolbox for the selection of rendering mode.
 * 
 * @author Radek Oslejsek
 */
public class RenderingModeToolbox extends JPopupMenu {
    
    private static final String SMOOT_BUTTON_ICON = "smooth-tri28x28.png";
    private static final String WIREFRAME_BUTTON_ICON = "wireframe-tri28x28.png";
    private static final String POINTS_BUTTON_ICON = "points-tri28x28.png";
    
    private final Canvas canvas;
    
    /**
     * Constructor.
     * @param canvas Rendering canvas
     */
    public RenderingModeToolbox(Canvas canvas) {
        this.canvas = canvas;
        initComponents();
    }
    
    private void initComponents() {
        JMenuItem menuItem1 = new JMenuItem(new AbstractAction() { // fill
            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < canvas.getScene().getNumFaces(); i++){
                   canvas.getScene().getDrawableFace(i).setRenderMode(GL2.GL_FILL);
                }
                canvas.renderScene();
            }
        });
        
        JMenuItem menuItem2 = new JMenuItem(new AbstractAction() { // lines
            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < canvas.getScene().getNumFaces(); i++){
                   canvas.getScene().getDrawableFace(i).setRenderMode(GL2.GL_LINE);
                }
                canvas.renderScene();
            }
        });
        
        JMenuItem menuItem3 = new JMenuItem(new AbstractAction() { // points
            @Override
            public void actionPerformed(ActionEvent e) {
                for (int i = 0; i < canvas.getScene().getNumFaces(); i++){
                   canvas.getScene().getDrawableFace(i).setRenderMode(GL2.GL_POINT);
                }
                canvas.renderScene();
            }
        });
        
        menuItem1.setIcon(new ImageIcon(getClass().getResource("/" + RenderingModeToolbox.SMOOT_BUTTON_ICON)));
        menuItem2.setIcon(new ImageIcon(getClass().getResource("/" + RenderingModeToolbox.WIREFRAME_BUTTON_ICON)));
        menuItem3.setIcon(new ImageIcon(getClass().getResource("/" + RenderingModeToolbox.POINTS_BUTTON_ICON)));

        menuItem1.setToolTipText(NbBundle.getMessage(RenderingModeToolbox.class, "RenderingModeToolbox.smooth.text"));
        menuItem2.setToolTipText(NbBundle.getMessage(RenderingModeToolbox.class, "RenderingModeToolbox.wireframe.text"));
        menuItem3.setToolTipText(NbBundle.getMessage(RenderingModeToolbox.class, "RenderingModeToolbox.pointcloud.text"));
        
        add(menuItem1);
        add(menuItem2);
        add(menuItem3);
        
        setLayout(new GridLayout(1,0));        
    }
}
