package cz.fidentis.analyst.canvas;

import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;

/**
 * Listener invoked when the OpenGL canvas is initiated, shown, or resized.
 * 
 * @author Radek Oslejsek
 */
public class CanvasListener implements GLEventListener {
    
    private Canvas canvas;
    
    /**
     * Constructor.
     * 
     * @param canvas Canvas
     * @throws IllegalArgumentException if the canvas is {@code null}
     */
    public CanvasListener(Canvas canvas) {
        if (canvas == null) {
            throw new IllegalArgumentException("canvas is null");
        }
        this.canvas = canvas;
    }
    
    @Override
    public void init(GLAutoDrawable glad) {
        //System.out.println("CanvasListener.init");
        canvas.getSceneRenderer().initGLContext(glad.getGL().getGL2());
    }

    @Override
    public void dispose(GLAutoDrawable glad) {
        //System.out.println("CanvasListener.dispose");
    }

    @Override
    public void display(GLAutoDrawable glad) {
        canvas.getSceneRenderer().renderScene(canvas.getCamera(), canvas.getScene().getAllDrawables());
        //OutputWindow.print("3D canvas has been rendered, window size " 
        //        + canvas.getWidth() + "x" + canvas.getHeight()
        //        +", GL canvas size " + canvas.getGLCanvas().getWidth() + "x" + canvas.getGLCanvas().getHeight()
        //);
    }

    @Override
    public void reshape(GLAutoDrawable glad, int x, int y, int width, int height) {
        canvas.getSceneRenderer().setViewport(x, y, width, height);
    }
    
}
