/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.icp.Icp;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import java.awt.Color;
import javax.swing.JColorChooser;
import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;

/**
 *
 * @author Richard Pajerský
 * 
 * Window for Registration
 */
@ConvertAsProperties(
        dtd = "-//cz.fidentis.analyst.gui//Aligment//EN",
        autostore = false
)
@TopComponent.Description(
        preferredID = "AligmentTopComponent",
        //iconBase="SET/PATH/TO/ICON/HERE",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS
)
@TopComponent.Registration(mode = "editor", openAtStartup = false)
@ActionID(category = "Window", id = "cz.fidentis.analyst.gui.AligmentTopComponent")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_AligmentAction",
        preferredID = "AligmentTopComponent"
)
@Messages({
    "CTL_AligmentAction=Registration",
    "CTL_AligmentTopComponent=Registration",
    "HINT_AligmentTopComponent=This is a Registration window"
})
public final class AligmentTopComponent extends TopComponent {

    private RegistrationGLEventListener regListener;
    
    public AligmentTopComponent() {
        initComponents();
        setName(Bundle.CTL_AligmentTopComponent());
        setToolTipText(Bundle.HINT_AligmentTopComponent());
        regListener = new RegistrationGLEventListener(canvas1, canvas2);
        canvas1.setListener(regListener);
        Manipulator3D manipulator = new Manipulator3D(regListener);
        canvas1.setManipulator(manipulator);
        primaryColorPanel.setBackground(regListener.getPrimaryColor());
        secondaryColorPanel.setBackground(regListener.getSecondaryColor());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        primaryColorPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        secondaryColorPanel = new javax.swing.JPanel();
        jSplitPane1 = new javax.swing.JSplitPane();
        canvas1 = new cz.fidentis.analyst.gui.Canvas();
        canvas2 = new cz.fidentis.analyst.gui.Canvas();

        setMinimumSize(new java.awt.Dimension(1200, 500));
        setPreferredSize(new java.awt.Dimension(1250, 600));

        jPanel1.setMinimumSize(new java.awt.Dimension(100, 500));
        jPanel1.setPreferredSize(new java.awt.Dimension(200, 600));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(AligmentTopComponent.class, "AligmentTopComponent.jLabel1.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jButton1, org.openide.util.NbBundle.getMessage(AligmentTopComponent.class, "AligmentTopComponent.jButton1.text")); // NOI18N
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        primaryColorPanel.setPreferredSize(new java.awt.Dimension(100, 40));
        primaryColorPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                primaryColorPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout primaryColorPanelLayout = new javax.swing.GroupLayout(primaryColorPanel);
        primaryColorPanel.setLayout(primaryColorPanelLayout);
        primaryColorPanelLayout.setHorizontalGroup(
            primaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        primaryColorPanelLayout.setVerticalGroup(
            primaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 40, Short.MAX_VALUE)
        );

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(AligmentTopComponent.class, "AligmentTopComponent.jLabel2.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(AligmentTopComponent.class, "AligmentTopComponent.jLabel3.text")); // NOI18N

        secondaryColorPanel.setPreferredSize(new java.awt.Dimension(100, 40));
        secondaryColorPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                secondaryColorPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout secondaryColorPanelLayout = new javax.swing.GroupLayout(secondaryColorPanel);
        secondaryColorPanel.setLayout(secondaryColorPanelLayout);
        secondaryColorPanelLayout.setHorizontalGroup(
            secondaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 100, Short.MAX_VALUE)
        );
        secondaryColorPanelLayout.setVerticalGroup(
            secondaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 40, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel1)
                    .addComponent(jButton1)
                    .addComponent(primaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(jLabel3)
                    .addComponent(secondaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 100, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButton1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel2)
                .addGap(5, 5, 5)
                .addComponent(primaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(secondaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );

        canvas1.setMinimumSize(new java.awt.Dimension(300, 0));
        canvas1.setName(""); // NOI18N
        canvas1.setPreferredSize(new java.awt.Dimension(500, 0));
        jSplitPane1.setLeftComponent(canvas1);

        canvas2.setMinimumSize(new java.awt.Dimension(300, 0));
        canvas2.setPreferredSize(new java.awt.Dimension(500, 0));
        jSplitPane1.setRightComponent(canvas2);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 578, Short.MAX_VALUE))
                    .addComponent(jSplitPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 589, Short.MAX_VALUE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        canvas1.changeModel(canvas2.getLoadedFace().getMeshModel());
    }//GEN-LAST:event_jButton1ActionPerformed

    private void primaryColorPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_primaryColorPanelMouseClicked
        Color current = primaryColorPanel.getBackground();
        Color newColor = JColorChooser.showDialog(null, "Choose a color", current);
        primaryColorPanel.setBackground(newColor);
        regListener.setPrimaryColor(newColor);
    }//GEN-LAST:event_primaryColorPanelMouseClicked

    private void secondaryColorPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_secondaryColorPanelMouseClicked
        Color current = secondaryColorPanel.getBackground();
        Color newColor = JColorChooser.showDialog(null, "Choose a color", current);
        secondaryColorPanel.setBackground(newColor);
        regListener.setSecondaryColor(newColor);
    }//GEN-LAST:event_secondaryColorPanelMouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private cz.fidentis.analyst.gui.Canvas canvas1;
    private cz.fidentis.analyst.gui.Canvas canvas2;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JPanel primaryColorPanel;
    private javax.swing.JPanel secondaryColorPanel;
    // End of variables declaration//GEN-END:variables
    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }
}
