package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

/**
 * MeshModel is a root node of the hierarchy
 *
 * @author Matej Lukes
 */
public class MeshModel {
    private List<MeshFacet> facets = new ArrayList<>();

    /**
     * Constructor of MeshModel
     */
    public MeshModel() {

    }

    /**
     * Copy constructor of MeshModel
     *
     * @param meshModel copied MeshModel
     */
    public MeshModel(MeshModel meshModel) {
        for (MeshFacet facet: meshModel.facets) {
            facets.add(new MeshFacetImpl(facet));
        }
    }

    /**
     * returns list of MeshFacets
     *
     * @return list of MeshFacets
     */
    public List<MeshFacet> getFacets() {
        return facets;
    }

    /**
     * adds new MeshFacet to the model
     *
     * @param facet new MeshFacet
     */
    public void addFacet(MeshFacet facet) {
        facets.add(facet);
    }
}
