package cz.fidentis.analyst.mesh.core;


import cz.fidentis.analyst.feature.api.IPosition;
import java.io.Serializable;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

/**
 * MeshPoint represents a point with position, normal, and texture coordinates
 *
 * @author Matej Lukes
 */
public interface MeshPoint extends IPosition, Serializable {
    
    /**
     * Helper method that calculates distance of two 3D points.
     * 
     * @param v1 The first 3D point. Must not be null.
     * @param v2 The second 3D point. Must not be null.
     * @return distance
     * @throws NullPointerException if some input parameter is missing.
     */
    static double distance(Point3d v1, Point3d v2) {
        return Math.sqrt(Math.pow(v1.x - v2.x, 2)
                + Math.pow(v1.y - v2.y, 2)
                + Math.pow(v1.z - v2.z, 2));
    }
    
    /**
     * @return normal
     */
    Vector3d getNormal();

    /**
     * @return position
     */
    Point3d getPosition();
    
    /**
     * 
     * @param newPos New position, must not be {@code null}
     */
    void setPosition(Point3d newPos);
    
    /**
     * Sets the normal vector
     * @param newNormal New normal vector or {@code null}
     */
    void setNormal(Vector3d newNormal);

    /**
     * @return texture coordinates
     */
    Vector3d getTexCoord();

}
