package cz.fidentis.analyst.feature;

import java.io.Serializable;

/**
 * Class with basic structure of feature point 
 * 
 * @author Jakub Kolman
 */
public class FeaturePointType implements Serializable {

    private final int type;         // sometimes refered to as ID (such as in class @FeaturePointTypeProvider)
    private final String name;
    private final String info;
    private final String code;

    /**
     * Constructor
     * 
     * @param type
     * @param name
     * @param info
     * @param code 
     */
    public FeaturePointType(int type, String name, String info, String code) {
        this.type = type;
        this.name = name;
        this.info = info;
        this.code = code;
    }

    public int getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public String getInfo() {
        return info;
    }

    public String getCode() {
        return code;
    }
}
