package cz.fidentis.analyst.mesh.events;

import com.google.common.eventbus.Subscribe;

/**
 * Objects implementing this interface can be registered with 
 * a {@link cz.fidentis.analyst.mesh.core.MeshModel} object 
 * and then be informed when the mesh model changes.
 * 
 * @author Radek Oslejsek
 */
public interface MeshListener {

    /**
     * Captures events fired by {@link cz.fidentis.analyst.mesh.core.MeshModel}.
     * 
     * @param event A fired event.
     */
    @Subscribe
    void meshEvent(MeshEvent event);
    
}
