package cz.fidentis.analyst.tests;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.mesh.core.MeshPoint;
import cz.fidentis.analyst.visitors.mesh.Curvature;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Vector3d;

/**
 * A class for testing curvature algorithms.
 * 
 * @author radek oslejsek
 */
public class CurvatureTests {

    private static File faceFile2 = new File("src/test/resources/cz/fidentis/analyst/00002_01_ECA.obj");
    private static File girlFile = new File("src/test/resources/cz/fidentis/analyst/average_girl_17-20.obj");
    
    /**
     * Main method 
     * @param args Input arguments 
     * @throws IOException on IO error
     */
    public static void main(String[] args) throws IOException {
        HumanFace face = new HumanFace(girlFile);
        //HumanFace face = new HumanFace(faceFile2);
        
        System.out.println("MODEL: " + face.getMeshModel());
        
        Set<MeshPoint> uniqueVerts = new HashSet<>(face.getMeshModel().getFacets().get(0).getVertices());
        System.out.println("UNIQUE VERTICES: " + uniqueVerts.size());
        Set<Vector3d> unique2 = new HashSet<>();
        for (MeshPoint p: face.getMeshModel().getFacets().get(0).getVertices()) {
            unique2.add(p.getPosition());
        }
        //System.out.println("UNIQUE VERTICES: " + unique2.size());
        //for (Vector3d v: unique2) {
        //    for (MeshPoint p: uniqueVerts) {
        //        if (v.equals(p.getPosition())) {
        //            System.out.println(p);
        //        }
        //    }
        //    System.out.println("----------------");
        //}
        
        boolean print = true;
        
        System.out.println();
        System.out.println("Curvature calculation:");
        System.out.println(measureCurvature(face, print) + "\tmsec:\tCurvature");
        System.out.println();
    }
    
    private static long measureCurvature(HumanFace face, boolean printDetails) {
        Curvature vis = new Curvature();
        long startTime = System.currentTimeMillis();
        face.getMeshModel().compute(vis);
        long retTime =  System.currentTimeMillis() - startTime;
        
        if (printDetails) {
            List<Double> distanceList = vis.getGaussianCurvatures().get(face.getMeshModel().getFacets().get(0));
            Double minDistance = distanceList.stream().mapToDouble(Double::doubleValue).min().getAsDouble();
            Double maxDistance = distanceList.stream().mapToDouble(Double::doubleValue).max().getAsDouble();
            System.out.println("Gaus min-max: " + minDistance + " .. " + maxDistance);
            
            distanceList = vis.getMeanCurvatures().get(face.getMeshModel().getFacets().get(0));
            minDistance = distanceList.stream().mapToDouble(Double::doubleValue).min().getAsDouble();
            maxDistance = distanceList.stream().mapToDouble(Double::doubleValue).max().getAsDouble();
            System.out.println("Mean min-max: " + minDistance + " .. " + maxDistance);
        }
        
        return retTime;
    }
}
