package cz.fidentis.analyst.visitors;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point3d;

/**
 * Classes implementing this interface are able to compute minimal distance and also
 * return concrete points from the closest mesh facets.
 * <p>
 * The distance computation can be either absolute or relative. Absolute means
 * that the Euclidean distance between 3D points in space is used. Because only 
 * positive distances are taken into calculation, then the minimum distance is 
 * the smallest found distance.
 * </p>
 * <p>
 * Relative distance also takes the normal vector of the 3D point into acount. 
 * If the "measured" point is located in the half space of the normal direction, 
 * then the distance is positive. Otherwise, the distance is negative. 
 * The minimum distance is a value "closest to zero".
 * </p>
 * 
 * @author Radek Oslejsek
 */
public interface DistanceWithNearestPoints extends Distance {
    
    /**
     * Returns closest mesh facets and their closest points
     * @return closest mesh facets and their closest points
     */
    Map<MeshFacet, List<Point3d>> getNearestPoints();
}
