package cz.fidentis.analyst.mesh.core;

import javax.vecmath.Vector3d;

/**
 * MeshPoint represents a point with position, normal, and texture coordinates
 *
 * @author Matej Lukes
 */
public class MeshPoint {
    private final Vector3d position, normal, texCoord;

    /**
     * constructor of meshPoint
     * @param position position of MeshPoint
     * @param normal normal of MeshPoint
     * @param texCoord coordinates in texture
     */
    public MeshPoint(Vector3d position, Vector3d normal , Vector3d texCoord) {
        if (position == null || normal == null || texCoord == null) {
            throw new NullPointerException("position, normal and texCoord cannot be null");
        }

        this.position = position;
        this.normal = normal;
        this.texCoord = texCoord;
    }

    /**
     * @return normal
     */
    public Vector3d getNormal() {
        return normal;
    }

    /**
     * @return position
     */
    public Vector3d getPosition() {
        return position;
    }

    /**
     * @return texture coordinates
     */
    public Vector3d getTexCoord() {
        return texCoord;
    }

    /**
     * @param obj compared object
     * @return true if positions, normals and texture coordinates are equal, false otherwise
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MeshPoint)) {
            return false;
        }

        MeshPoint meshPointObj = (MeshPoint) obj;
        return this.position.equals(meshPointObj.position)
                && this.normal.equals(meshPointObj.normal)
                && this.texCoord.equals(meshPointObj.texCoord);
    }

    /**
     * returns hash of MeshPoint
     * @return hash
     */
    @Override
    public int hashCode() {
        return position.hashCode() + normal.hashCode() + texCoord.hashCode();
    }
}
