package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

/**
 * MashFacet
 *
 * @author Matej Lukes
 */
public class MeshFacet {
    private List<MeshPoint> vertices = new ArrayList<>();
    private CornerTable cornerTable = new CornerTable();

    /**
     * returns vertex of specified index
     *
     * @param index index of vertex
     * @return vertex
     */
    public MeshPoint getVertex(int index) {
        return vertices.get(index);
    }

    /**
     * returns all vertices
     *
     * @return list of vertices
     */
    public List<MeshPoint> getVertices() {
        return vertices;
    }

    /**
     * returns list of vertices in triangle
     *
     * @param triangleIndex index of triangle
     * @return list of vertices
     */
    public List<MeshPoint> getVerticesOfTriangle(int triangleIndex) {
        List<MeshPoint> vertices = new ArrayList<>(3);
        for (int i = 0; i < 3; i++) {
            vertices.add(vertices.get(cornerTable.getRow(triangleIndex + i).getVertexIndex()));
        }
        return vertices;
    }


    /**
     * adds vertex to MeshFacet
     *
     * @param point new vertex
     */
    public void addVertex(MeshPoint point) {
        vertices.add(point);
    }

    /**
     * returns number of vertexes in MeshFacet
     *
     * @return number of vertexes
     */
    public int getNumberOfVertexes() {
        return vertices.size();
    }

    /**
     * returns Corner Table representing MeshFacet
     *
     * @return corner table
     */
    public CornerTable getCornerTable() {
        return cornerTable;
    }
}

