package cz.fidentis.analyst.gui.core;

import com.jogamp.opengl.GL2;
import cz.fidentis.analyst.gui.canvas.Canvas;
import cz.fidentis.analyst.gui.scene.DrawableMesh;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import org.openide.awt.Mnemonics;

/**
 * Rendering toolbar.
 * 
 * @author Radek Oslejsek
 */
public class RenderingToolBar extends JToolBar {
    
    public static final int WIDTH = 40;
    
    public enum Button {
        WIREFRAME,
        BACKGROUND;
        
        @Override
        public String toString() {
            switch (this) {
                case WIREFRAME:
                    return "wireframe";
                case BACKGROUND:
                    return "background";
                default:
                    return toString();
            }
        }
    }

    private final Map<Button, JButton> buttons = new HashMap<>();
    
    private final Canvas canvas;
    
    public RenderingToolBar(Canvas canvas) {
        this.canvas = canvas;
        initToolBar();
        initButtons();
        initEvents();
    }
    
    private void initToolBar() {
        setOrientation(javax.swing.SwingConstants.VERTICAL);
        setRollover(true);
        setFloatable(false);
    }
    
    private void initButtons() {
        for (Button butEnum: Button.values()) {
            JButton button = new JButton();
            URL icon = getClass().getResource("/" + butEnum + "32x32.png");
            if (icon != null) {
                button.setIcon(new ImageIcon(getClass().getResource("/" + butEnum + "32x32.png")));
            }
            Mnemonics.setLocalizedText(button, org.openide.util.NbBundle.getMessage(RenderingToolBar.class, "RenderingToolBar." + butEnum +".text"));
            button.setFocusable(false);
            button.setHorizontalTextPosition(SwingConstants.CENTER);
            button.setVerticalTextPosition(SwingConstants.BOTTOM);
            buttons.put(butEnum, button);
            add(button);
        }
    }
    
    private void initEvents() {
        for (Button butEnum: Button.values()) {
            JButton button = buttons.get(butEnum);
            
            button.addMouseListener(new MouseAdapter() {
                @Override
                public void mouseClicked(MouseEvent evt) {
                    switch (butEnum) {
                        case WIREFRAME:
                            wireframeButtonClicked(evt);
                            break;
                        case BACKGROUND:
                            backgroundButtonClicked(evt);
                            break;
                    }
                }
            });
        }
    }
    
    private void wireframeButtonClicked(MouseEvent evt) {
        boolean on = buttons.get(Button.WIREFRAME).isSelected();
        for (DrawableMesh dm: canvas.getScene().getDrawables()) {
            if (on) {
                dm.setRenderMode(GL2.GL_FILL);
                buttons.get(Button.WIREFRAME).setSelected(false);
            } else {
                dm.setRenderMode(GL2.GL_LINE);
                buttons.get(Button.WIREFRAME).setSelected(true);
            }
        }
        canvas.renderScene();
    }
    
    private void backgroundButtonClicked(MouseEvent evt) {
        boolean on = buttons.get(Button.BACKGROUND).isSelected();
        if (on) {
            canvas.getSceneRenderer().setDarkBackground();
            buttons.get(Button.BACKGROUND).setSelected(false);
        } else {
            canvas.getSceneRenderer().setBrightBackground();
            buttons.get(Button.BACKGROUND).setSelected(true);
        }
        canvas.renderScene();
    }
}
