package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.project.ProjectTopComp;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.openide.modules.ModuleInstall;

/**
 * GUI initialization class.
 * 
 * @author Radek Oslejsek
 */
public class Installer extends ModuleInstall {
    
    private ProjectTopComp projectTopComp;
    
    /**
     * Constructor with projectTopComp
     * @param projectTopComp ProjectTopComp
     */
    public Installer(ProjectTopComp projectTopComp) {
        this.projectTopComp = projectTopComp;   
    }
    
    /**
     * Default constructor
     */
    public Installer() {
        //super();
    }
    
    @Override
    public void restored() {
        /*
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                //System.out.println(info.getName());
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException | InstantiationException | IllegalAccessException | javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Installer.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        */
        java.awt.EventQueue.invokeLater(() -> {
            //old JFrame, disabled
            /*frameMain = new UserInterface();
            frameMain.setBackground(new Color(49,165,154));
            frameMain.pack();
            frameMain.setVisible(true);*/          
            //enables to use design of operating system
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }catch(ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            }
        });
    }
    
    @Override
    public boolean closing() {
        
        if (projectTopComp != null) {
            projectTopComp.saveProjectOnClose();
        }
        
        int answer = JOptionPane.showConfirmDialog(null,
                "Do you really want to close the application?", "", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
        return answer == JOptionPane.YES_OPTION;
    }

    
}
