package cz.fidentis.analyst.filter;

import cz.fidentis.analyst.feature.FeaturePointType;
import cz.fidentis.analyst.feature.provider.FeaturePointTypeProvider;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

/**
 *
 * @author Matej Kovar
 */
public class FeaturePointsFilterPanel extends JPanel {
 
    private List<JCheckBox> featurePointCheckBoxes;
    private List<FeaturePointType> selectedFeaturePoints = new ArrayList<>();
    
    /**
     * Constructor
     */
    public void initComponents() {
        
        setLayout(new GridBagLayout());
        
        // Load all types of feature points
        FeaturePointTypeProvider typeProvider = FeaturePointTypeProvider.getInstance();
        Map<Integer, FeaturePointType> fpMap = typeProvider.getFeaturePointTypesById();
        List<FeaturePointType> featurePoints = fpMap.values().stream()
                .collect(Collectors.toList());
        
        featurePointCheckBoxes = new ArrayList<>();
        
        for (int i = 0; i < featurePoints.size(); i++) {
            addRow(i, featurePoints.get(i));
        }
        
    }

    protected void addRow(int row, FeaturePointType featurePoint) {
        
        GridBagConstraints c1 = new GridBagConstraints();  
        c1.insets = new Insets(0, 0, 0, 0);
        c1.gridwidth = 1;
        c1.gridx = 0;
        c1.gridy = row;
        c1.anchor = GridBagConstraints.WEST;
        c1.fill = GridBagConstraints.NONE;

        JCheckBox checkBox = new JCheckBox();
        checkBox.setSelected(false);
        checkBox.setEnabled(false);
        checkBox.setText(featurePoint.getName());
        add(checkBox, c1);
        featurePointCheckBoxes.add(checkBox);
        
        checkBox.addActionListener(new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (!selectedFeaturePoints.remove(featurePoint)) {
                    selectedFeaturePoints.add(featurePoint);
                }
            }
        });
    }
    
    /**
     * Deselects and disables(enables) all check boxes with each feature point type
     * @param enable enables or disables check boxes
     */
    public void disableCheckBoxes(boolean enable) {
        featurePointCheckBoxes.forEach(ch -> {
            
            if (!enable) {
                ch.setSelected(false);
            }
            ch.setEnabled(enable);
        });
    }

    public List<FeaturePointType> getSelectedFeaturePoints() {
        return selectedFeaturePoints;
    }
    
    @Override
    public void setEnabled(boolean enable) {
        this.getParent().setEnabled(enable);
        disableCheckBoxes(enable);
    }
    
}
