package cz.fidentis.analyst.core;

import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * A single line input field that lets the user show and select real number
 * from an ordered sequence. 
 * 
 * @author Radek Oslejsek
 */
public class DoubleSpinner extends JSpinner {
    
    private int fractionDigits = 2;

    private static final double STEP_RATIO = 0.1;

    private SpinnerNumberModel model;

    /**
     * Constructor.
     * 
     * @param fractionDigits precision of flouting numbers, 
     * i.e., the number of digits allowed after the floating dot
     */
    public DoubleSpinner(int fractionDigits) {
        this.fractionDigits = fractionDigits;

        model = new SpinnerNumberModel(0.0, -getRecomputationFactor(), getRecomputationFactor(), 0.1);
        this.setModel(model);
        //model.setMinimum(min);
        //smodel.setMinimum(max);
        
        // Step recalculation
        this.addChangeListener(new ChangeListener() {
            @Override
            public void stateChanged(ChangeEvent e) {
                Double value = getDouble();
                // Steps are sensitive to the current magnitude of the value
                long magnitude = Math.round(Math.log10(value));
                double stepSize = STEP_RATIO * Math.pow(10, magnitude);
                if (stepSize == 0.0) {
                    stepSize = 0.1;
                }
                model.setStepSize(stepSize);
            }
        });
        
    }

    /**
     * Returns the current value as a Double
     */
    public Double getDouble() {
        return (Double) getValue();
    }

    /**
     * Returns 1, 10, 100, etc., based on the fraction digits.
     * @return 1, 10, 100, etc., based on the fraction digits.
     */
    public double getRecomputationFactor() {
        int scale = 1;
        for (int i = 0; i < fractionDigits; i++) {
            scale *= 10;
        }
        return scale;
    }
}