package cz.fidentis.analyst.face;

import java.util.Comparator;

/**
 * Comparator for HumanFace faces
 * 
 * @author Matej Kovar
 */
public class FaceStateComparator implements Comparator<HumanFace> {
    /*
    private boolean kdTreeFilter = false;
    private boolean featurePointsFilter = false;
    private boolean alphabeticalFilter = false;

    public FaceStateComparator(boolean kdTreeFilter, boolean featurePointsFilter, boolean alphabeticalFilter) {
        this.kdTreeFilter = kdTreeFilter;
        this.featurePointsFilter = featurePointsFilter;
        this.alphabeticalFilter = alphabeticalFilter;
    }*/
    
    @Override
    public int compare(HumanFace face1, HumanFace face2) {
        int comparison;
        
        comparison = Boolean.compare(face1.hasFeaturePoints(), face2.hasFeaturePoints());
        
        // Both have feature points
        if (comparison == 0) {
            
            comparison = Boolean.compare(face1.hasKdTree(), face2.hasKdTree());
            
            // Both have KD Tree
            if (comparison == 0) {
                
                // Alphabeticaly
                comparison = face1.getShortName().compareTo(face2.getShortName());
            }
        }
        
        return comparison; 
    }

    
}
