package cz.fidentis.analyst.project;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.project.events.AllFacesLoaded;
import cz.fidentis.analyst.project.events.ProjectEvent;
import cz.fidentis.analyst.project.events.ProjectListener;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

/**
 *
 * @author Matej Kovar
 */
public class FilterPanel extends ControlPanel implements ProjectListener {
    
    private boolean kdTreeFilter = false;
    private boolean featurePointsFilter = false;
    private boolean alphabeticalFilter = false;


    public static final String ICON = "filter28x28.png";
    public static final String NAME = "Filter";

    /**
     * Creates new form FilterPanel
     */
    public FilterPanel(ActionListener listenerLoadAllFaces) {
        this.setName(NAME);
        initComponents();
        loadAllModelsButton.addActionListener(listenerLoadAllFaces);
        //applyFilterButton.addActionListener(buttonListener);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        filterPanel = new javax.swing.JPanel();
        hasFP = new javax.swing.JCheckBox();
        hasKD = new javax.swing.JCheckBox();
        alphabetical = new javax.swing.JCheckBox();
        applyFilterButton = new javax.swing.JButton();
        warningLabel = new javax.swing.JLabel();
        faceNotLoadedLabel = new javax.swing.JLabel();
        loadAllModelsButton = new javax.swing.JButton();

        filterPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.filterPanel.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12))); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(hasFP, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasFP.text")); // NOI18N
        hasFP.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hasFPActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(hasKD, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.hasKD.text")); // NOI18N
        hasKD.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                hasKDActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(alphabetical, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.alphabetical.text")); // NOI18N
        alphabetical.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                alphabeticalActionPerformed(evt);
            }
        });

        applyFilterButton.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(applyFilterButton, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.applyFilterButton.text")); // NOI18N
        applyFilterButton.setEnabled(false);

        warningLabel.setIcon(new javax.swing.ImageIcon(getClass().getResource("/warning16x16.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(warningLabel, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.warningLabel.text")); // NOI18N
        warningLabel.setVisible(false);

        faceNotLoadedLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(faceNotLoadedLabel, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.faceNotLoadedLabel.text")); // NOI18N
        faceNotLoadedLabel.setVisible(false);

        loadAllModelsButton.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(loadAllModelsButton, org.openide.util.NbBundle.getMessage(FilterPanel.class, "FilterPanel.loadAllModelsButton.text")); // NOI18N
        loadAllModelsButton.setVisible(false);

        javax.swing.GroupLayout filterPanelLayout = new javax.swing.GroupLayout(filterPanel);
        filterPanel.setLayout(filterPanelLayout);
        filterPanelLayout.setHorizontalGroup(
            filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(filterPanelLayout.createSequentialGroup()
                .addGap(38, 38, 38)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(applyFilterButton)
                    .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(alphabetical)
                        .addComponent(hasKD)
                        .addComponent(hasFP)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 201, Short.MAX_VALUE)
                .addComponent(loadAllModelsButton)
                .addGap(89, 89, 89))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, filterPanelLayout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(warningLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(faceNotLoadedLabel)
                .addGap(22, 22, 22))
        );
        filterPanelLayout.setVerticalGroup(
            filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(filterPanelLayout.createSequentialGroup()
                .addGap(40, 40, 40)
                .addComponent(hasFP)
                .addGap(18, 18, 18)
                .addComponent(hasKD)
                .addGap(18, 18, 18)
                .addComponent(alphabetical)
                .addGap(19, 19, 19)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(warningLabel)
                    .addComponent(faceNotLoadedLabel))
                .addGap(23, 23, 23)
                .addGroup(filterPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(applyFilterButton)
                    .addComponent(loadAllModelsButton))
                .addContainerGap(69, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(filterPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(filterPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(270, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Sets attribute to corresponding value based on checkbox
     * @param evt 
     */
    private void hasFPActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hasFPActionPerformed
        featurePointsFilter = (((JCheckBox)evt.getSource()).isSelected());
    }//GEN-LAST:event_hasFPActionPerformed

    /**
     * Sets attribute to corresponding value based on checkbox
     * @param evt 
     */
    private void hasKDActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_hasKDActionPerformed
        kdTreeFilter = (((JCheckBox)evt.getSource()).isSelected());
    }//GEN-LAST:event_hasKDActionPerformed

    /**
     * Sets attribute to corresponding value based on checkbox
     * @param evt 
     */
    private void alphabeticalActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_alphabeticalActionPerformed
        alphabeticalFilter = (((JCheckBox)evt.getSource()).isSelected());
    }//GEN-LAST:event_alphabeticalActionPerformed

    @Override
    public ImageIcon getIcon() {
        return new ImageIcon(FilterPanel.class.getClassLoader().getResource("/" + ICON));
    }

    /**
     * Sets ActionListener to apply filter button
     * @param applyFilterListener ActionListener
     */
    public void setFilterActionListener(ActionListener applyFilterListener) {
        applyFilterButton.addActionListener(applyFilterListener);
    }
    
    public boolean isKdTreeFilter() {
        return kdTreeFilter;
    }

    public boolean isFeaturePointsFilter() {
        return featurePointsFilter;
    }

    public boolean isAlphabeticalFilter() {
        return alphabeticalFilter;
    }
    
    /**
     * Checks if all faces in list are loaded. If not, button which loads all
     * faces from list shows up
     * @param isAllFacesLoaded Boolean
     */
    public void checkAllFacesLoaded(boolean isAllFacesLoaded) {
        
        warningLabel.setVisible(!isAllFacesLoaded);
        faceNotLoadedLabel.setVisible(!isAllFacesLoaded);
        loadAllModelsButton.setVisible(!isAllFacesLoaded);
        applyFilterButton.setEnabled(isAllFacesLoaded);
    }
    
    @Override
    public void acceptEvent(ProjectEvent event) {
        
        if (event.getClass() == AllFacesLoaded.class) {
            
            AllFacesLoaded evt = (AllFacesLoaded)event;
            this.checkAllFacesLoaded(evt.isAllFacesLoaded());
        }
    }

    

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox alphabetical;
    private javax.swing.JButton applyFilterButton;
    private javax.swing.JLabel faceNotLoadedLabel;
    private javax.swing.JPanel filterPanel;
    private javax.swing.JCheckBox hasFP;
    private javax.swing.JCheckBox hasKD;
    private javax.swing.JButton loadAllModelsButton;
    private javax.swing.JLabel warningLabel;
    // End of variables declaration//GEN-END:variables

}
