package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.mesh.io.MeshObjLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.vecmath.Vector3d;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

/**
 * @author Radek Oslejsek
 */
public class TriangleListVisitorTest {
    
    Path testFileDirectory = Paths.get("src", "test", "resources", "cz", "fidentis", "analyst");
    
    @Test
    void icoSphereTest() throws IOException {
        MeshModel m = MeshObjLoader.read(new File(testFileDirectory.toFile(), "IcoSphere-20.obj"));
        assertNotNull(m);
        TriangleListVisitor visitor = new TriangleListVisitor();
        m.compute(visitor);
        assertEquals(20, visitor.getTriangles().size());
    }
    
    @Test
    void combinedTest() throws IOException {
        MeshModel m = MeshObjLoader.read(new File(testFileDirectory.toFile(), "IcoSphere-20.obj"));
        assertNotNull(m);
        TriangleListVisitor visitor = new TriangleListVisitor();
        m.compute(visitor);
        
        m = MeshObjLoader.read(new File(testFileDirectory.toFile(), "Tetrahedron.obj"));
        assertNotNull(m);
        m.compute(visitor);
        
        assertEquals(24, visitor.getTriangles().size());
    }
}
