package cz.fidentis.analyst.scene;

import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.symmetry.Plane;

import javax.vecmath.Vector3d;

/**
 * A cutting plane.
 * 
 * @author Radek Oslejsek
 */
public class DrawablePlane extends DrawableMesh {
    
    private final Plane plane;
    
    /**
     * Constructor.
     * @param model Mesh model of the plane
     * @param plane The plane
     */
    public DrawablePlane(MeshModel model, Plane plane) {
        super(model);
        if (plane == null) {
            throw new IllegalArgumentException("plane");
        }
        this.plane = plane;
    }
    
    /**
     * Constructor.
     * @param facet Mesh facet of the plane
     * @param plane The plane
     */
    public DrawablePlane(MeshFacet facet, Plane plane) {
        super(facet);
        if (plane == null) {
            throw new IllegalArgumentException("plane");
        }
        this.plane = new Plane(plane);
    }

    public Plane getPlane() {
        return plane;
    }

    /**
     * Translate the plane along its normal
     *
     * @param value
     */
    public void translatePlane(double value) {
        // Move real plane
        this.plane.translate(value);

        // Move Drawable plane
        Vector3d move = this.plane.getNormal();
        move.x *= value;
        move.y *= value;
        move.z *= value;

        for (int i = 0; i < 4; ++i) {
            getFacets().get(0).getVertex(i).getPosition().sub(move);
        }
    }
}
