package cz.fidentis.analyst.toolbar;

import cz.fidentis.analyst.canvas.Canvas;
import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.distance.DistanceAction;
import cz.fidentis.analyst.distance.DistancePanel;
import cz.fidentis.analyst.registration.RegistrationAction;
import cz.fidentis.analyst.registration.RegistrationPanel;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import org.openide.util.NbBundle;

/**
 * A toolbar extension for the analysis of two faces.
 * 
 * @author Radek Oslejsek
 */
public class FaceToFaceToolBar extends RenderingToolBar {
    
    /**
     * Constructor.
     * 
     * @param canvas Rendering canvas
     * @param controlPanel The top component control panels
     */
    public FaceToFaceToolBar(Canvas canvas, JTabbedPane controlPanel) {
        super(canvas);
        addPrimaryFaceButton();
        addSecondaryFaceButton();
        addSeparator();
        addDistanceButton(controlPanel);
        addRegistrationButton(controlPanel);
    }
    
    private void addDistanceButton(JTabbedPane controlPanel) {
        JToggleButton button = new JToggleButton();
        button.addActionListener(new DistanceAction(getCanvas(), controlPanel));
        button.setActionCommand(ControlPanel.ACTION_COMMAND_SHOW_HIDE_PANEL);
        button.setIcon(DistancePanel.getStaticIcon());
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "FaceToFaceToolBar.distance.text"));
        add(button);
    }
    
    private void addRegistrationButton(JTabbedPane controlPanel) {
        JToggleButton button = new JToggleButton();
        button.addActionListener(new RegistrationAction(getCanvas(), controlPanel));
        button.setActionCommand(ControlPanel.ACTION_COMMAND_SHOW_HIDE_PANEL);
        button.setIcon(RegistrationPanel.getStaticIcon());
        button.setToolTipText(NbBundle.getMessage(RenderingToolBar.class, "FaceToFaceToolBar.registration.text"));
        add(button);
    }
}
