package cz.fidentis.analyst.canvas;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

/**
 * Action listener for {@link ControlButtons}.
 * 
 * @author Radek Oslejsek
 */
public class ControlButtonsAction extends AbstractAction {
    
    public static final String ACTION_COMMAND_LEFT_PRESSED = "rotate left pressed";
    public static final String ACTION_COMMAND_LEFT_RELEASED = "rotate left released";
    public static final String ACTION_COMMAND_RIGHT_PRESSED = "rotate right pressed";
    public static final String ACTION_COMMAND_RIGHT_RELEASED = "rotate right released";
    public static final String ACTION_COMMAND_UP_PRESSED = "rotate up pressed";
    public static final String ACTION_COMMAND_UP_RELEASED = "rotate up released";
    public static final String ACTION_COMMAND_DOWN_PRESSED = "rotate down pressed";
    public static final String ACTION_COMMAND_DOWN_RELEASED = "rotate down released";
    public static final String ACTION_COMMAND_PLUS_PRESSED = "zoom in pressed";
    public static final String ACTION_COMMAND_PLUS_RELEASED = "zoom in released";
    public static final String ACTION_COMMAND_MINUS_PRESSED = "zoom out pressed";
    public static final String ACTION_COMMAND_MINUS_RELEASED = "zoom out released";
    public static final String ACTION_COMMAND_RESET = "reset";

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        
        switch (command) {
            case ACTION_COMMAND_LEFT_PRESSED:
                break;
            case ACTION_COMMAND_LEFT_RELEASED:
                break;
            case ACTION_COMMAND_RIGHT_PRESSED:
                break;
            case ACTION_COMMAND_RIGHT_RELEASED:
                break;
            case ACTION_COMMAND_UP_PRESSED:
                break;
            case ACTION_COMMAND_UP_RELEASED:
                break;
            case ACTION_COMMAND_DOWN_PRESSED:
                break;
            case ACTION_COMMAND_DOWN_RELEASED:
                break;
            case ACTION_COMMAND_RESET:
                break;
            case ACTION_COMMAND_PLUS_PRESSED:
                break;
            case ACTION_COMMAND_PLUS_RELEASED:
                break;
            case ACTION_COMMAND_MINUS_PRESSED:
                break;
            case ACTION_COMMAND_MINUS_RELEASED:
                break;
            default:
                throw new UnsupportedOperationException(command);
        }
    }
    
}
