package cz.fidentis.analyst.dashboard;

import cz.fidentis.analyst.core.ControlPanelBuilder;
import cz.fidentis.analyst.face.HumanFace;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * Panel for showing face state information
 * 
 * @author Matej Kovar
 */
public final class FaceStatePanel extends JPanel {

    private final JPanel controlPanel;
    
    private final ImageIcon notCheck = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "notCheck16x16.png"));
    private final ImageIcon check = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "check16x16.png"));
    private final JLabel hasKDtree;
    private final JLabel hasFeaturePoints;
    private final JLabel tmp1;
    private final JLabel tmp2;
    private final JLabel tmp3;

    /**
     * Constructor
     * @param controlPanel control panel where components will be added
     * @param face HumanFace, its state info will be shown
     */
    public FaceStatePanel(JPanel controlPanel, HumanFace face) {
        
        this.controlPanel = controlPanel;
        this.controlPanel.removeAll();
        ControlPanelBuilder builder = new ControlPanelBuilder(this.controlPanel);
        
        builder.addCaptionLine("Face state");
        builder.addLine();
        
        hasKDtree = builder.addLabelLine("Has KD-tree calculated");
        if (face.hasKdTree()) {
            hasKDtree.setIcon(check);
        } else {
            hasKDtree.setIcon(notCheck);
        }
        builder.addLine();

        hasFeaturePoints = builder.addLabelLine("Has Feature points");
        if (face.hasFeaturePoints()) {
            hasFeaturePoints.setIcon(check);
        } else {
            hasFeaturePoints.setIcon(notCheck);
        }
        builder.addLine();

        tmp1 = builder.addLabelLine("...");
        tmp1.setIcon(notCheck);
        builder.addLine();

        tmp2 = builder.addLabelLine("...");
        tmp2.setIcon(notCheck);
        builder.addLine();

        tmp3 = builder.addLabelLine("...");
        tmp3.setIcon(notCheck);
        builder.addLine();
    }  
}
