package cz.fidentis.analyst.gui;

import java.awt.Color;
import java.awt.Cursor;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

/**
 *
 * @author Natalia Bebjakova
 *
 * Main window of the applicaion
 */

public class Interface extends javax.swing.JFrame {
    boolean pressedNewProject = false;
    boolean maximizePressed = false;
    boolean wiredModelClicked = false;
    private JPanel actualPanel;

    public static JFrame frameMain; //main frame of the application
    int xMouse;
    int yMouse;

    /**
     * Creates new form Interface
     */
    public Interface() {
        //this.setUndecorated(true);
        initComponents();
        topPanel.setVisible(false);
        setCursorOnComponents();
        actualPanel = startingPanel;
    }
    /**
     * Sets hand cursor when moving mouse on components
     */
    private void setCursorOnComponents() {
        newProject.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        texture.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        close.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        maximize.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        JLabel11.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        jLabel4.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        symetryMain.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        reloadModelButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        wiredModelButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        homeButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        viewerButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
        reloadModelButton1.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    }

    /**
     * Enables to switch between panels
     * @param panel New panel that will be visible
     */
    private void switchPanelOnMainPanel(JPanel panel) {
        actualPanel = panel;
        jPanel2.removeAll();
        jPanel2.repaint();
        jPanel2.revalidate();
        jPanel2.add(panel);
        jPanel2.repaint();
        jPanel2.revalidate();
        panel.add(jPanel1);
        jPanel1.setVisible(true);
        /*if(maximizePressed) {
            frameMain.setExtendedState(this.getExtendedState() | JFrame.MAXIMIZED_BOTH);
        }*/
    }

    /**
     * Changes backround of labels to darker green color
     * @param jl label of which backround changes
     */
    public void setLabelBackround(JLabel jl) {
        jl.setBackground(new Color(11,56,49));
    }
    public void resetLabelBackround(JLabel jl) {
        jl.setBackground(new Color(20,114,105));
    }

    /**
     * Changes backround of panel to brighter color and adds border
     * @param jp panel of which backround changes
     */
    public void setPanelBackround(JPanel jp) {
        jp.setBackground(new Color(11,56,49));
        jp.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 4, Color.WHITE));
    }
    public void resetPanelBackround(JPanel jp) {
        jp.setBackground(new Color(20,114,105));
        jp.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.WHITE));
    }

    /**
     * Changes backround of panel to darker color and adds border
     * @param jp panel of which backround changes
     */
    public void setPanelBackroundMain(JPanel jp) {
        jp.setBackground(new Color(106,198,187));
        jp.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 4, Color.WHITE));
    }
    public void resetPanelBackroundMain(JPanel jp) {
        jp.setBackground(new Color(0,174,163));
        jp.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 0, Color.WHITE));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */


    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        topPanel = new javax.swing.JPanel();
        compareTwo = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        compareDB = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        batchProcessing = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        symetryEstimator = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        newProject = new javax.swing.JLabel();
        texture = new javax.swing.JLabel();
        close = new javax.swing.JLabel();
        maximize = new javax.swing.JLabel();
        wiredModelButton = new javax.swing.JLabel();
        homeButton = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        startingPanel = new javax.swing.JPanel();
        javax.swing.JLabel logo = new javax.swing.JLabel();
        jPanel3 = new javax.swing.JPanel();
        compareTwoMain = new javax.swing.JPanel();
        JLabel8 = new javax.swing.JLabel();
        compareTwoMain1 = new javax.swing.JPanel();
        JLabel9 = new javax.swing.JLabel();
        batchMain = new javax.swing.JPanel();
        JLabel10 = new javax.swing.JLabel();
        symetryMain = new javax.swing.JPanel();
        JLabel11 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        viewerButton = new javax.swing.JLabel();
        symetryPanel = new javax.swing.JPanel();
        viewerPanel = new javax.swing.JPanel();
        canva1 = new cz.fidentis.analyst.gui.Canvas();
        reloadModelButton = new javax.swing.JLabel();
        symetrySpecificationPanel = new javax.swing.JPanel();
        curavatureSlider = new javax.swing.JSlider();
        angleCosineSlider = new javax.swing.JSlider();
        minCurvatio = new javax.swing.JLabel();
        minCurvatio2 = new javax.swing.JLabel();
        normalAngleSlider = new javax.swing.JSlider();
        minCurvatio3 = new javax.swing.JLabel();
        significantPointSlider = new javax.swing.JSlider();
        minCurvatio4 = new javax.swing.JLabel();
        relativeDistanceSlider = new javax.swing.JSlider();
        significantPointLabel = new javax.swing.JLabel();
        symetryButton = new javax.swing.JLabel();
        minCurvatio7 = new javax.swing.JLabel();
        averagingCheckBox = new javax.swing.JCheckBox();
        modelViewPanel = new javax.swing.JPanel();
        reloadModelButton1 = new javax.swing.JLabel();
        jPanel4 = new javax.swing.JPanel();
        canva2 = new cz.fidentis.analyst.gui.Canvas();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setAlwaysOnTop(true);
        setAutoRequestFocus(false);
        setBackground(new java.awt.Color(20, 114, 105));
        setLocationByPlatform(true);

        topPanel.setBackground(new java.awt.Color(20, 114, 105));

        compareTwo.setBackground(new java.awt.Color(20, 114, 105));
        compareTwo.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                compareTwoMouseMoved(evt);
            }
        });
        compareTwo.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                compareTwoMouseExited(evt);
            }
        });

        jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/compareTwo.png"))); // NOI18N

        javax.swing.GroupLayout compareTwoLayout = new javax.swing.GroupLayout(compareTwo);
        compareTwo.setLayout(compareTwoLayout);
        compareTwoLayout.setHorizontalGroup(
                compareTwoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoLayout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 154, Short.MAX_VALUE)
                                .addContainerGap())
        );
        compareTwoLayout.setVerticalGroup(
                compareTwoLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoLayout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 139, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap())
        );

        compareDB.setBackground(new java.awt.Color(20, 114, 105));
        compareDB.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                compareDBMouseMoved(evt);
            }
        });
        compareDB.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                compareDBMouseExited(evt);
            }
        });

        jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel2.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/copareWithDatabase.png"))); // NOI18N

        javax.swing.GroupLayout compareDBLayout = new javax.swing.GroupLayout(compareDB);
        compareDB.setLayout(compareDBLayout);
        compareDBLayout.setHorizontalGroup(
                compareDBLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(compareDBLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 162, Short.MAX_VALUE))
        );
        compareDBLayout.setVerticalGroup(
                compareDBLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareDBLayout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jLabel2)
                                .addContainerGap())
        );

        batchProcessing.setBackground(new java.awt.Color(20, 114, 105));
        batchProcessing.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                batchProcessingMouseMoved(evt);
            }
        });
        batchProcessing.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                batchProcessingMouseExited(evt);
            }
        });

        jLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel3.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/batchProcessing.png"))); // NOI18N

        javax.swing.GroupLayout batchProcessingLayout = new javax.swing.GroupLayout(batchProcessing);
        batchProcessing.setLayout(batchProcessingLayout);
        batchProcessingLayout.setHorizontalGroup(
                batchProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(batchProcessingLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(jLabel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addContainerGap())
        );
        batchProcessingLayout.setVerticalGroup(
                batchProcessingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, batchProcessingLayout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jLabel3)
                                .addContainerGap())
        );

        symetryEstimator.setBackground(new java.awt.Color(20, 114, 105));
        symetryEstimator.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                symetryEstimatorMouseMoved(evt);
            }
        });
        symetryEstimator.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                symetryEstimatorMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                symetryEstimatorMouseExited(evt);
            }
        });

        jLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        jLabel4.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/symetry.png"))); // NOI18N
        jLabel4.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                maximizeMouseMoved1(evt);
            }
        });
        jLabel4.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jLabel4MouseClicked(evt);
            }
        });

        javax.swing.GroupLayout symetryEstimatorLayout = new javax.swing.GroupLayout(symetryEstimator);
        symetryEstimator.setLayout(symetryEstimatorLayout);
        symetryEstimatorLayout.setHorizontalGroup(
                symetryEstimatorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(symetryEstimatorLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        symetryEstimatorLayout.setVerticalGroup(
                symetryEstimatorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetryEstimatorLayout.createSequentialGroup()
                                .addComponent(jLabel4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addContainerGap())
        );

        javax.swing.GroupLayout topPanelLayout = new javax.swing.GroupLayout(topPanel);
        topPanel.setLayout(topPanelLayout);
        topPanelLayout.setHorizontalGroup(
                topPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(topPanelLayout.createSequentialGroup()
                                .addContainerGap(339, Short.MAX_VALUE)
                                .addComponent(compareTwo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(105, 105, 105)
                                .addComponent(compareDB, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(86, 86, 86)
                                .addComponent(batchProcessing, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(97, 97, 97)
                                .addComponent(symetryEstimator, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(338, Short.MAX_VALUE))
        );
        topPanelLayout.setVerticalGroup(
                topPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, topPanelLayout.createSequentialGroup()
                                .addContainerGap(94, Short.MAX_VALUE)
                                .addGroup(topPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addComponent(symetryEstimator, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(compareDB, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(compareTwo, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(batchProcessing, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
        );

        jPanel1.setBackground(new java.awt.Color(20, 114, 105));
        jPanel1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jPanel1MouseDragged(evt);
            }
        });
        jPanel1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                jPanel1MousePressed(evt);
            }
        });

        newProject.setBackground(new java.awt.Color(20, 114, 105));
        newProject.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 18)); // NOI18N
        newProject.setForeground(new java.awt.Color(255, 255, 255));
        newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/new_project.png"))); // NOI18N
        newProject.setOpaque(true);
        newProject.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                newProjectMouseMoved(evt);
            }
        });
        newProject.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                newProjectMouseExited(evt);
            }
            public void mousePressed(java.awt.event.MouseEvent evt) {
                newProjectMousePressed(evt);
            }
        });

        texture.setBackground(new java.awt.Color(20, 114, 105));
        texture.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/texture2.png"))); // NOI18N
        texture.setOpaque(true);
        texture.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                textureMouseMoved(evt);
            }
        });
        texture.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                textureMouseExited(evt);
            }
        });

        close.setBackground(new java.awt.Color(20, 114, 105));
        close.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/close.png"))); // NOI18N
        close.setOpaque(true);
        close.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                closeMouseMoved(evt);
            }
        });
        close.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                closeMouseExited(evt);
            }
            public void mousePressed(java.awt.event.MouseEvent evt) {
                closeMousePressed(evt);
            }
        });

        maximize.setBackground(new java.awt.Color(20, 114, 105));
        maximize.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/maximize.png"))); // NOI18N
        maximize.setOpaque(true);
        maximize.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                maximizeMouseMoved(evt);
            }
        });
        maximize.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                maximizeMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                maximizeMouseExited(evt);
            }
        });

        wiredModelButton.setBackground(new java.awt.Color(20, 114, 105));
        wiredModelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/wireframe.png"))); // NOI18N
        wiredModelButton.setOpaque(true);
        wiredModelButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                wiredModelButtonMouseMoved(evt);
            }
        });
        wiredModelButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                wiredModelButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                wiredModelButtonMouseExited(evt);
            }
        });

        homeButton.setBackground(new java.awt.Color(20, 114, 105));
        homeButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/home.png"))); // NOI18N
        homeButton.setOpaque(true);
        homeButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                homeButtonMouseMoved(evt);
            }
        });
        homeButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                homeButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                homeButtonMouseExited(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
                jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel1Layout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(homeButton)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(newProject, javax.swing.GroupLayout.PREFERRED_SIZE, 198, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(texture)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(wiredModelButton, javax.swing.GroupLayout.PREFERRED_SIZE, 187, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(maximize)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(close)
                                .addContainerGap())
        );
        jPanel1Layout.setVerticalGroup(
                jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addComponent(texture, javax.swing.GroupLayout.DEFAULT_SIZE, 77, Short.MAX_VALUE)
                                        .addComponent(newProject, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(close, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(wiredModelButton, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(maximize, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                        .addComponent(homeButton, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );

        jPanel2.setLayout(new java.awt.CardLayout());

        startingPanel.setBackground(new java.awt.Color(0, 174, 163));
        startingPanel.setToolTipText("");

        logo.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/logo3.png"))); // NOI18N

        jPanel3.setBackground(new java.awt.Color(0, 174, 163));
        jPanel3.setToolTipText("");

        compareTwoMain.setBackground(new java.awt.Color(0, 174, 163));
        compareTwoMain.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                compareTwoMainMouseMoved(evt);
            }
        });
        compareTwoMain.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                compareTwoMainMouseExited(evt);
            }
        });

        JLabel8.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/compareTwoGreen.png"))); // NOI18N

        javax.swing.GroupLayout compareTwoMainLayout = new javax.swing.GroupLayout(compareTwoMain);
        compareTwoMain.setLayout(compareTwoMainLayout);
        compareTwoMainLayout.setHorizontalGroup(
                compareTwoMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(compareTwoMainLayout.createSequentialGroup()
                                .addGap(15, 15, 15)
                                .addComponent(JLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, 142, Short.MAX_VALUE)
                                .addContainerGap())
        );
        compareTwoMainLayout.setVerticalGroup(
                compareTwoMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoMainLayout.createSequentialGroup()
                                .addGap(0, 28, Short.MAX_VALUE)
                                .addComponent(JLabel8, javax.swing.GroupLayout.PREFERRED_SIZE, 142, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        compareTwoMain1.setBackground(new java.awt.Color(0, 174, 163));
        compareTwoMain1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                compareTwoMain1MouseMoved(evt);
            }
        });
        compareTwoMain1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                compareTwoMain1MouseExited(evt);
            }
        });

        JLabel9.setBackground(new java.awt.Color(0, 174, 163));
        JLabel9.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/copareWithDatabaseGreen.png"))); // NOI18N

        javax.swing.GroupLayout compareTwoMain1Layout = new javax.swing.GroupLayout(compareTwoMain1);
        compareTwoMain1.setLayout(compareTwoMain1Layout);
        compareTwoMain1Layout.setHorizontalGroup(
                compareTwoMain1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoMain1Layout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(JLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 160, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap())
        );
        compareTwoMain1Layout.setVerticalGroup(
                compareTwoMain1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, compareTwoMain1Layout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(JLabel9, javax.swing.GroupLayout.DEFAULT_SIZE, 156, Short.MAX_VALUE))
        );

        batchMain.setBackground(new java.awt.Color(0, 174, 163));
        batchMain.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                batchMainMouseMoved(evt);
            }
        });
        batchMain.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                batchMainMouseExited(evt);
            }
        });

        JLabel10.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/batchProcessingGreen.png"))); // NOI18N

        javax.swing.GroupLayout batchMainLayout = new javax.swing.GroupLayout(batchMain);
        batchMain.setLayout(batchMainLayout);
        batchMainLayout.setHorizontalGroup(
                batchMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, batchMainLayout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(JLabel10)
                                .addContainerGap())
        );
        batchMainLayout.setVerticalGroup(
                batchMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, batchMainLayout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addComponent(JLabel10, javax.swing.GroupLayout.PREFERRED_SIZE, 157, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        symetryMain.setBackground(new java.awt.Color(0, 174, 163));
        symetryMain.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                symetryMainMouseMoved(evt);
            }
        });
        symetryMain.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                symetryMainMouseExited(evt);
            }
        });

        JLabel11.setBackground(new java.awt.Color(0, 174, 163));
        JLabel11.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/symetryGreen.png"))); // NOI18N
        JLabel11.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                JLabel11MouseMoved(evt);
            }
        });
        JLabel11.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                JLabel11MouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                JLabel11MouseExited(evt);
            }
        });

        javax.swing.GroupLayout symetryMainLayout = new javax.swing.GroupLayout(symetryMain);
        symetryMain.setLayout(symetryMainLayout);
        symetryMainLayout.setHorizontalGroup(
                symetryMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetryMainLayout.createSequentialGroup()
                                .addGap(0, 12, Short.MAX_VALUE)
                                .addComponent(JLabel11))
        );
        symetryMainLayout.setVerticalGroup(
                symetryMainLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetryMainLayout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addComponent(JLabel11, javax.swing.GroupLayout.PREFERRED_SIZE, 161, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        jLabel6.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/divide.png"))); // NOI18N

        viewerButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/modelView.png"))); // NOI18N
        viewerButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                viewerButtonMouseMoved(evt);
            }
        });
        viewerButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                viewerButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                viewerButtonMouseExited(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
                jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel3Layout.createSequentialGroup()
                                .addContainerGap(278, Short.MAX_VALUE)
                                .addComponent(viewerButton)
                                .addGap(227, 227, 227)
                                .addComponent(jLabel6)
                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                                .addGap(135, 135, 135)
                                                .addComponent(compareTwoMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                                .addGap(130, 130, 130)
                                                .addComponent(compareTwoMain1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addGap(81, 81, 81)
                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(batchMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                                .addGap(12, 12, 12)
                                                .addComponent(symetryMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addGap(243, 243, 243))
        );
        jPanel3Layout.setVerticalGroup(
                jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup()
                                .addGap(27, 27, 27)
                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addGroup(jPanel3Layout.createSequentialGroup()
                                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                                        .addComponent(compareTwoMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                        .addComponent(batchMain, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                        .addComponent(symetryMain, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                        .addComponent(compareTwoMain1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                                .addContainerGap())
                        .addGroup(jPanel3Layout.createSequentialGroup()
                                .addGap(71, 71, 71)
                                .addComponent(viewerButton)
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout startingPanelLayout = new javax.swing.GroupLayout(startingPanel);
        startingPanel.setLayout(startingPanelLayout);
        startingPanelLayout.setHorizontalGroup(
                startingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(startingPanelLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addContainerGap())
                        .addGroup(startingPanelLayout.createSequentialGroup()
                                .addGap(714, 714, 714)
                                .addComponent(logo, javax.swing.GroupLayout.PREFERRED_SIZE, 218, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        startingPanelLayout.setVerticalGroup(
                startingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(startingPanelLayout.createSequentialGroup()
                                .addGap(198, 198, 198)
                                .addComponent(logo, javax.swing.GroupLayout.PREFERRED_SIZE, 124, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(135, 135, 135)
                                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(200, 200, 200))
        );

        jPanel2.add(startingPanel, "card3");

        symetryPanel.setBackground(new java.awt.Color(0, 174, 163));

        canva1.addMouseWheelListener(new java.awt.event.MouseWheelListener() {
            public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
                canva1MouseWheelMoved(evt);
            }
        });

        javax.swing.GroupLayout viewerPanelLayout = new javax.swing.GroupLayout(viewerPanel);
        viewerPanel.setLayout(viewerPanelLayout);
        viewerPanelLayout.setHorizontalGroup(
                viewerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(viewerPanelLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(canva1, javax.swing.GroupLayout.DEFAULT_SIZE, 652, Short.MAX_VALUE)
                                .addContainerGap())
        );
        viewerPanelLayout.setVerticalGroup(
                viewerPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, viewerPanelLayout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(canva1, javax.swing.GroupLayout.DEFAULT_SIZE, 858, Short.MAX_VALUE)
                                .addContainerGap())
        );

        reloadModelButton.setBackground(new java.awt.Color(0, 174, 163));
        reloadModelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/loadModel.png"))); // NOI18N
        reloadModelButton.setOpaque(true);
        reloadModelButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                reloadModelButtonMouseMoved(evt);
            }
        });
        reloadModelButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                reloadModelButtonMouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                reloadModelButtonMouseExited(evt);
            }
        });

        symetrySpecificationPanel.setBackground(new java.awt.Color(176, 230, 226));
        symetrySpecificationPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                symetrySpecificationPanelMouseClicked(evt);
            }
        });

        curavatureSlider.setBackground(new java.awt.Color(250, 250, 250));
        curavatureSlider.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        curavatureSlider.setOpaque(false);

        angleCosineSlider.setOpaque(false);

        minCurvatio.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 14)); // NOI18N
        minCurvatio.setForeground(new java.awt.Color(20, 114, 105));
        minCurvatio.setText("Min. Curvature Ratio");

        minCurvatio2.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 14)); // NOI18N
        minCurvatio2.setForeground(new java.awt.Color(20, 114, 105));
        minCurvatio2.setText("Min. Angle Cosine");

        normalAngleSlider.setOpaque(false);

        minCurvatio3.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 14)); // NOI18N
        minCurvatio3.setForeground(new java.awt.Color(20, 114, 105));
        minCurvatio3.setText("Max. Relative Distance");

        significantPointSlider.setOpaque(false);

        minCurvatio4.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 14)); // NOI18N
        minCurvatio4.setForeground(new java.awt.Color(20, 114, 105));
        minCurvatio4.setText("Min. Normal Angle Cosine");

        relativeDistanceSlider.setOpaque(false);

        significantPointLabel.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 14)); // NOI18N
        significantPointLabel.setForeground(new java.awt.Color(20, 114, 105));
        significantPointLabel.setText("Significant Point Count");

        symetryButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/symetryCount.png"))); // NOI18N
        symetryButton.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                symetryButtonMouseMoved(evt);
            }
        });
        symetryButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseExited(java.awt.event.MouseEvent evt) {
                symetryButtonMouseExited(evt);
            }
        });

        minCurvatio7.setFont(new java.awt.Font("Neue Haas Unica Pro", 0, 14)); // NOI18N
        minCurvatio7.setForeground(new java.awt.Color(20, 114, 105));
        minCurvatio7.setText("Averaging");

        averagingCheckBox.setSelected(true);
        averagingCheckBox.setOpaque(false);

        javax.swing.GroupLayout symetrySpecificationPanelLayout = new javax.swing.GroupLayout(symetrySpecificationPanel);
        symetrySpecificationPanel.setLayout(symetrySpecificationPanelLayout);
        symetrySpecificationPanelLayout.setHorizontalGroup(
                symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetrySpecificationPanelLayout.createSequentialGroup()
                                .addContainerGap(80, Short.MAX_VALUE)
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addComponent(minCurvatio)
                                        .addComponent(minCurvatio2)
                                        .addComponent(minCurvatio3)
                                        .addComponent(minCurvatio4)
                                        .addGroup(symetrySpecificationPanelLayout.createSequentialGroup()
                                                .addComponent(significantPointLabel)
                                                .addGap(13, 13, 13))
                                        .addGroup(symetrySpecificationPanelLayout.createSequentialGroup()
                                                .addComponent(minCurvatio7)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                                .addComponent(averagingCheckBox)))
                                .addGap(18, 18, 18)
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(significantPointSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 244, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(normalAngleSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 244, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(angleCosineSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 244, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(curavatureSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 244, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(relativeDistanceSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 244, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addComponent(symetryButton, javax.swing.GroupLayout.Alignment.TRAILING))
                                .addGap(133, 133, 133))
        );
        symetrySpecificationPanelLayout.setVerticalGroup(
                symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(symetrySpecificationPanelLayout.createSequentialGroup()
                                .addGap(72, 72, 72)
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addComponent(curavatureSlider, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(minCurvatio, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(40, 40, 40)
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                        .addComponent(angleCosineSlider, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(minCurvatio2, javax.swing.GroupLayout.PREFERRED_SIZE, 26, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(40, 40, 40)
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(normalAngleSlider, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(minCurvatio4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addGap(38, 38, 38)
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(minCurvatio3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(relativeDistanceSlider, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addGap(41, 41, 41)
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(symetrySpecificationPanelLayout.createSequentialGroup()
                                                .addComponent(significantPointLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 26, Short.MAX_VALUE)
                                                .addGap(36, 36, 36))
                                        .addGroup(symetrySpecificationPanelLayout.createSequentialGroup()
                                                .addComponent(significantPointSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 35, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                                .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(symetryButton, javax.swing.GroupLayout.PREFERRED_SIZE, 75, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addGroup(symetrySpecificationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                                .addComponent(averagingCheckBox)
                                                .addComponent(minCurvatio7, javax.swing.GroupLayout.PREFERRED_SIZE, 28, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addGap(102, 102, 102))
        );

        javax.swing.GroupLayout symetryPanelLayout = new javax.swing.GroupLayout(symetryPanel);
        symetryPanel.setLayout(symetryPanelLayout);
        symetryPanelLayout.setHorizontalGroup(
                symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(symetryPanelLayout.createSequentialGroup()
                                .addContainerGap(136, Short.MAX_VALUE)
                                .addComponent(viewerPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 105, Short.MAX_VALUE)
                                .addGroup(symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addComponent(reloadModelButton)
                                        .addComponent(symetrySpecificationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addContainerGap(112, Short.MAX_VALUE))
        );
        symetryPanelLayout.setVerticalGroup(
                symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, symetryPanelLayout.createSequentialGroup()
                                .addGap(118, 118, 118)
                                .addGroup(symetryPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addGroup(symetryPanelLayout.createSequentialGroup()
                                                .addComponent(symetrySpecificationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 242, Short.MAX_VALUE)
                                                .addComponent(reloadModelButton))
                                        .addComponent(viewerPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                                .addGap(182, 182, 182))
        );

        jPanel2.add(symetryPanel, "card3");

        modelViewPanel.setBackground(new java.awt.Color(0, 174, 163));
        modelViewPanel.setToolTipText("");

        reloadModelButton1.setBackground(new java.awt.Color(0, 174, 163));
        reloadModelButton1.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/loadModel.png"))); // NOI18N
        reloadModelButton1.setOpaque(true);
        reloadModelButton1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                reloadModelButton1MouseMoved(evt);
            }
        });
        reloadModelButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                reloadModelButton1MouseClicked(evt);
            }
            public void mouseExited(java.awt.event.MouseEvent evt) {
                reloadModelButton1MouseExited(evt);
            }
        });

        canva2.addMouseWheelListener(new java.awt.event.MouseWheelListener() {
            public void mouseWheelMoved(java.awt.event.MouseWheelEvent evt) {
                canva2MouseWheelMoved(evt);
            }
        });

        javax.swing.GroupLayout jPanel4Layout = new javax.swing.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
                jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(jPanel4Layout.createSequentialGroup()
                                .addContainerGap()
                                .addComponent(canva2, javax.swing.GroupLayout.DEFAULT_SIZE, 1040, Short.MAX_VALUE)
                                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
                jPanel4Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup()
                                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(canva2, javax.swing.GroupLayout.PREFERRED_SIZE, 778, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap())
        );

        javax.swing.GroupLayout modelViewPanelLayout = new javax.swing.GroupLayout(modelViewPanel);
        modelViewPanel.setLayout(modelViewPanelLayout);
        modelViewPanelLayout.setHorizontalGroup(
                modelViewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(modelViewPanelLayout.createSequentialGroup()
                                .addContainerGap(141, Short.MAX_VALUE)
                                .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(35, 35, 35)
                                .addComponent(reloadModelButton1)
                                .addGap(244, 244, 244))
        );
        modelViewPanelLayout.setVerticalGroup(
                modelViewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, modelViewPanelLayout.createSequentialGroup()
                                .addContainerGap(162, Short.MAX_VALUE)
                                .addGroup(modelViewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addComponent(reloadModelButton1)
                                        .addComponent(jPanel4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addContainerGap(218, Short.MAX_VALUE))
        );

        jPanel2.add(modelViewPanel, "card4");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addComponent(topPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(topPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addContainerGap(835, Short.MAX_VALUE))
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                        .addGap(0, 0, Short.MAX_VALUE)
                                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        pack();
        setLocationRelativeTo(null);
    }// </editor-fold>//GEN-END:initComponents

    private void newProjectMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newProjectMouseMoved
        setLabelBackround(newProject);
    }//GEN-LAST:event_newProjectMouseMoved

    private void newProjectMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newProjectMouseExited
        if (!pressedNewProject) {
            resetLabelBackround(newProject);
        }
    }//GEN-LAST:event_newProjectMouseExited

    private void textureMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_textureMouseMoved
        setLabelBackround(texture);
    }//GEN-LAST:event_textureMouseMoved

    private void textureMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_textureMouseExited
        resetLabelBackround(texture);
    }//GEN-LAST:event_textureMouseExited

    private void closeMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_closeMouseMoved
        setLabelBackround(close);
    }//GEN-LAST:event_closeMouseMoved

    private void closeMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_closeMouseExited
        resetLabelBackround(close);
    }//GEN-LAST:event_closeMouseExited

    private void closeMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_closeMousePressed
        System.exit(0);
    }//GEN-LAST:event_closeMousePressed

    private void compareTwoMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareTwoMouseMoved
        setPanelBackround(compareTwo);
    }//GEN-LAST:event_compareTwoMouseMoved

    private void compareTwoMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareTwoMouseExited
        resetPanelBackround(compareTwo);
    }//GEN-LAST:event_compareTwoMouseExited

    private void compareDBMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareDBMouseMoved
        setPanelBackround(compareDB);
    }//GEN-LAST:event_compareDBMouseMoved

    private void compareDBMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareDBMouseExited
        resetPanelBackround(compareDB);
    }//GEN-LAST:event_compareDBMouseExited

    private void batchProcessingMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_batchProcessingMouseMoved
        setPanelBackround(batchProcessing);
    }//GEN-LAST:event_batchProcessingMouseMoved

    private void batchProcessingMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_batchProcessingMouseExited
        resetPanelBackround(batchProcessing);
    }//GEN-LAST:event_batchProcessingMouseExited

    private void maximizeMouseMoved1(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_maximizeMouseMoved1

    }//GEN-LAST:event_maximizeMouseMoved1

    private void symetryEstimatorMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryEstimatorMouseExited
        resetPanelBackround(symetryEstimator);
    }//GEN-LAST:event_symetryEstimatorMouseExited

    private void newProjectMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_newProjectMousePressed
        if(pressedNewProject) {
            topPanel.setVisible(false);
            pressedNewProject = false;
            switchPanelOnMainPanel(actualPanel);
            newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/new_project.png")));
        }else{
            topPanel.setVisible(true);
            topPanel.add(jPanel1);
            pressedNewProject = true;
            newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/new_project_opened.png")));
        }
    }//GEN-LAST:event_newProjectMousePressed

    private void maximizeMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_maximizeMouseMoved
        setLabelBackround(maximize);
    }//GEN-LAST:event_maximizeMouseMoved

    private void maximizeMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_maximizeMouseExited
        resetLabelBackround(maximize);
    }//GEN-LAST:event_maximizeMouseExited


    private void maximizeMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_maximizeMouseClicked
        /*if(maximizePressed) {
            frameMain.setExtendedState(JFrame.NORMAL);
            maximizePressed = false;
        } else {
            frameMain.setExtendedState(this.getExtendedState() | JFrame.MAXIMIZED_BOTH);
            maximizePressed = true;
        }*/
    }//GEN-LAST:event_maximizeMouseClicked

    private void symetryEstimatorMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryEstimatorMouseMoved
        setPanelBackround(symetryEstimator);
    }//GEN-LAST:event_symetryEstimatorMouseMoved

    private void compareTwoMainMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareTwoMainMouseMoved
        setPanelBackroundMain(compareTwoMain);
    }//GEN-LAST:event_compareTwoMainMouseMoved

    private void compareTwoMainMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareTwoMainMouseExited
        resetPanelBackroundMain(compareTwoMain);
    }//GEN-LAST:event_compareTwoMainMouseExited

    private void compareTwoMain1MouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareTwoMain1MouseMoved
        setPanelBackroundMain(compareTwoMain1);
    }//GEN-LAST:event_compareTwoMain1MouseMoved

    private void compareTwoMain1MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_compareTwoMain1MouseExited
        resetPanelBackroundMain(compareTwoMain1);
    }//GEN-LAST:event_compareTwoMain1MouseExited

    private void batchMainMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_batchMainMouseMoved
        setPanelBackroundMain(batchMain);
    }//GEN-LAST:event_batchMainMouseMoved

    private void batchMainMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_batchMainMouseExited
        resetPanelBackroundMain(batchMain);
    }//GEN-LAST:event_batchMainMouseExited

    private void symetryMainMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryMainMouseMoved
        setPanelBackroundMain(symetryMain);
    }//GEN-LAST:event_symetryMainMouseMoved

    private void symetryMainMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryMainMouseExited
        resetPanelBackroundMain(symetryMain);
    }//GEN-LAST:event_symetryMainMouseExited

    private void JLabel11MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JLabel11MouseClicked
        switchPanelOnMainPanel(symetryPanel);
    }//GEN-LAST:event_JLabel11MouseClicked

    private void symetryEstimatorMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryEstimatorMouseClicked
        switchPanelOnMainPanel(symetryPanel);
        topPanel.setVisible(false);
        newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/new_project.png")));
        resetLabelBackround(newProject);
    }//GEN-LAST:event_symetryEstimatorMouseClicked

    private void canva1MouseWheelMoved(java.awt.event.MouseWheelEvent evt) {//GEN-FIRST:event_canva1MouseWheelMoved
//to do to grab model
    }//GEN-LAST:event_canva1MouseWheelMoved

    private void jPanel1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jPanel1MouseDragged
        int x = evt.getXOnScreen();
        int y = evt.getYOnScreen();
        frameMain.setLocation(x - xMouse, y - yMouse);
    }//GEN-LAST:event_jPanel1MouseDragged

    private void jPanel1MousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jPanel1MousePressed
        xMouse  = evt.getX();
        yMouse = evt.getY();
    }//GEN-LAST:event_jPanel1MousePressed

    private void reloadModelButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButtonMouseMoved
        reloadModelButton.setBackground(new Color(176,230,226));
    }//GEN-LAST:event_reloadModelButtonMouseMoved

    private void reloadModelButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButtonMouseExited
        reloadModelButton.setBackground(new Color(0,174,163));
    }//GEN-LAST:event_reloadModelButtonMouseExited

    private void symetryButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryButtonMouseMoved
        symetryButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/symetryCountClicked.png")));
        symetryButton.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
    }//GEN-LAST:event_symetryButtonMouseMoved

    private void symetryButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetryButtonMouseExited
        symetryButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/symetryCount.png")));
    }//GEN-LAST:event_symetryButtonMouseExited

    private void symetrySpecificationPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_symetrySpecificationPanelMouseClicked

    }//GEN-LAST:event_symetrySpecificationPanelMouseClicked

    private void reloadModelButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButtonMouseClicked
        canva1.loadModel();
    }//GEN-LAST:event_reloadModelButtonMouseClicked

    private void wiredModelButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_wiredModelButtonMouseMoved

    }//GEN-LAST:event_wiredModelButtonMouseMoved

    private void wiredModelButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_wiredModelButtonMouseExited

    }//GEN-LAST:event_wiredModelButtonMouseExited

    /**
     *
     * @param evt letting know GLCanva if model will be displayed as wire-frame
     */
    private void wiredModelButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_wiredModelButtonMouseClicked
        if (wiredModelClicked) {
            resetLabelBackround(wiredModelButton);
            wiredModelClicked = false;
            canva1.setDrawWired(wiredModelClicked);
            canva2.setDrawWired(wiredModelClicked);
        } else {
            setLabelBackround(wiredModelButton);
            wiredModelClicked = true;
            canva1.setDrawWired(wiredModelClicked);
            canva2.setDrawWired(wiredModelClicked);
        }
    }//GEN-LAST:event_wiredModelButtonMouseClicked

    private void homeButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_homeButtonMouseMoved
        setLabelBackround(homeButton);
    }//GEN-LAST:event_homeButtonMouseMoved

    private void homeButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_homeButtonMouseExited
        resetLabelBackround(homeButton);
    }//GEN-LAST:event_homeButtonMouseExited

    private void homeButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_homeButtonMouseClicked
        switchPanelOnMainPanel(startingPanel);
    }//GEN-LAST:event_homeButtonMouseClicked

    private void reloadModelButton1MouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButton1MouseMoved
        reloadModelButton1.setBackground(new Color(176,230,226));
    }//GEN-LAST:event_reloadModelButton1MouseMoved

    private void reloadModelButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButton1MouseClicked
        canva2.loadModel();
    }//GEN-LAST:event_reloadModelButton1MouseClicked

    private void reloadModelButton1MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_reloadModelButton1MouseExited
        reloadModelButton1.setBackground(new Color(0,174,163));
    }//GEN-LAST:event_reloadModelButton1MouseExited

    private void canva2MouseWheelMoved(java.awt.event.MouseWheelEvent evt) {//GEN-FIRST:event_canva2MouseWheelMoved
        // TODO add your handling code here:
    }//GEN-LAST:event_canva2MouseWheelMoved

    private void viewerButtonMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_viewerButtonMouseClicked
        switchPanelOnMainPanel(modelViewPanel);
    }//GEN-LAST:event_viewerButtonMouseClicked


    private void JLabel11MouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JLabel11MouseMoved

    }//GEN-LAST:event_JLabel11MouseMoved

    private void viewerButtonMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_viewerButtonMouseMoved
        viewerButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/modelViewMoved.png")));
    }//GEN-LAST:event_viewerButtonMouseMoved

    private void viewerButtonMouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_viewerButtonMouseExited
        viewerButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/modelView.png")));
    }//GEN-LAST:event_viewerButtonMouseExited

    private void JLabel11MouseExited(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_JLabel11MouseExited

    }//GEN-LAST:event_JLabel11MouseExited

    private void jLabel4MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jLabel4MouseClicked
        switchPanelOnMainPanel(symetryPanel);
        topPanel.setVisible(false);
        newProject.setIcon(new javax.swing.ImageIcon(getClass().getResource("/resources/new_project.png")));
        resetLabelBackround(newProject);
    }//GEN-LAST:event_jLabel4MouseClicked

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        try {
            for (javax.swing.UIManager.LookAndFeelInfo info : javax.swing.UIManager.getInstalledLookAndFeels()) {
                if ("Nimbus".equals(info.getName())) {
                    javax.swing.UIManager.setLookAndFeel(info.getClassName());
                    break;
                }
            }
        } catch (ClassNotFoundException ex) {
            java.util.logging.Logger.getLogger(Interface.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            java.util.logging.Logger.getLogger(Interface.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            java.util.logging.Logger.getLogger(Interface.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        } catch (javax.swing.UnsupportedLookAndFeelException ex) {
            java.util.logging.Logger.getLogger(Interface.class.getName()).log(java.util.logging.Level.SEVERE, null, ex);
        }
        java.awt.EventQueue.invokeLater(new Runnable() {
            @Override
            public void run() {
                frameMain = new Interface();
                frameMain.setBackground(new Color(49,165,154));
                frameMain.pack();
                frameMain.setVisible(true);

                //enables to use design of operating system
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }catch(Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
    }




    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel JLabel10;
    private javax.swing.JLabel JLabel11;
    private javax.swing.JLabel JLabel8;
    private javax.swing.JLabel JLabel9;
    private javax.swing.JSlider angleCosineSlider;
    private javax.swing.JCheckBox averagingCheckBox;
    private javax.swing.JPanel batchMain;
    private javax.swing.JPanel batchProcessing;
    private cz.fidentis.analyst.gui.Canvas canva1;
    private cz.fidentis.analyst.gui.Canvas canva2;
    private javax.swing.JLabel close;
    private javax.swing.JPanel compareDB;
    private javax.swing.JPanel compareTwo;
    private javax.swing.JPanel compareTwoMain;
    private javax.swing.JPanel compareTwoMain1;
    private javax.swing.JSlider curavatureSlider;
    private javax.swing.JLabel homeButton;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JLabel maximize;
    private javax.swing.JLabel minCurvatio;
    private javax.swing.JLabel minCurvatio2;
    private javax.swing.JLabel minCurvatio3;
    private javax.swing.JLabel minCurvatio4;
    private javax.swing.JLabel minCurvatio7;
    private javax.swing.JPanel modelViewPanel;
    private javax.swing.JLabel newProject;
    private javax.swing.JSlider normalAngleSlider;
    private javax.swing.JSlider relativeDistanceSlider;
    private javax.swing.JLabel reloadModelButton;
    private javax.swing.JLabel reloadModelButton1;
    private javax.swing.JLabel significantPointLabel;
    private javax.swing.JSlider significantPointSlider;
    private javax.swing.JPanel startingPanel;
    private javax.swing.JLabel symetryButton;
    private javax.swing.JPanel symetryEstimator;
    private javax.swing.JPanel symetryMain;
    private javax.swing.JPanel symetryPanel;
    private javax.swing.JPanel symetrySpecificationPanel;
    private javax.swing.JLabel texture;
    private javax.swing.JPanel topPanel;
    private javax.swing.JLabel viewerButton;
    private javax.swing.JPanel viewerPanel;
    private javax.swing.JLabel wiredModelButton;
    // End of variables declaration//GEN-END:variables
}
