/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.animator;

import com.jogamp.opengl.util.FPSAnimator;
import cz.fidentis.analyst.gui.tab.PostRegistrationCP;
import java.util.Timer;
import java.util.TimerTask;

/**
 *
 * @author Richard Pajersky
 */
public class ModelRotationAnimator {
    
    /**
     * Frequency of the rotation or zoom animations
     */
    private static final int FPS = 60; 
    
    /**
     * Animator used when the rotation or zoom buttons are pressed and held
     */
    private final FPSAnimator animator;
    
    /*
     * Animatio timer
     */
    private long startClickTime = 0;
    private TimerTask task;
    private Timer timer;
    
    private Direction direction = Direction.NONE;
    
    /**
     * Constructor.
     */
    public ModelRotationAnimator() {
        this.animator = new FPSAnimator(FPS, true);
    }
    
    public void startModelAnimation(Direction dir, PostRegistrationCP panel) {
        if (this.direction != Direction.NONE) {
            throw new UnsupportedOperationException(); // this should no happen
        }
        
        animator.start();
        timer = new Timer();
        startClickTime = System.currentTimeMillis();
        task = new TimerTask() {
            @Override
            public void run() {
                panel.transform(dir);
            }
        };
        timer.schedule(task, 500, 100);
        
        this.direction = dir;        
    }
    
    /**
     * Stops the animation.
     */
    public void stopModelAnimation(PostRegistrationCP panel) {
        timer.cancel();
        if ((System.currentTimeMillis() - startClickTime) < 500) {
                panel.transform(direction);
        }
        startClickTime = 0;
        animator.stop();
        this.direction = Direction.NONE;
    }    
}
