package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;

/**
 * MashFacet
 *
 * @author Matej Lukes
 */
public class MeshFacetImpl implements MeshFacet {
    
    private List<MeshPoint> vertices = new ArrayList<>();
    private CornerTable cornerTable;

    /**
     * Constructor of MeshFacet
     */
    public MeshFacetImpl() {
        cornerTable = new CornerTable();
    }

    /**
     * Copy constructor of MeshFacet
     *
     * @param facet copied MeshFacet
     */
    public MeshFacetImpl(MeshFacet facet) {
        for (MeshPoint vertex: facet.getVertices()) {
            vertices.add(new MeshPointImpl(vertex));
        }
        cornerTable = new CornerTable(facet.getCornerTable());
    }

    @Override
    public MeshPoint getVertex(int index) {
        return vertices.get(index);
    }

    @Override
    public void addVertex(MeshPoint point) {
        vertices.add(point);
    }

    @Override
    public int getNumberOfVertices() {
        return vertices.size();
    }

    @Override
    public List<MeshPoint> getVertices() {
        return vertices;
    }

    @Override
    public CornerTable getCornerTable() {
        return cornerTable;
    }
}

