package cz.fidentis.analyst.mesh.core;

/**
 * single row in corner table
 *
 * @author Matej Lukes
 */
public class CornerTableRow {
    private int oppositeCornerIndex;
    private int vertexIndex;

    /**
     * Constructor of a row in corner
     *
     * @param vertexIndex         index of associated vertex in MashFacet
     * @param oppositeCornerIndex index of the opposite corner, -1 if there is no opposite corner
     */
    public CornerTableRow(int vertexIndex, int oppositeCornerIndex) {
        this.vertexIndex = vertexIndex;
        this.oppositeCornerIndex = oppositeCornerIndex;
    }

    /**
     * Copy constructor of a row in corner
     *
     * @param cornerTableRow copied row
     */
    public CornerTableRow(CornerTableRow cornerTableRow) {
        this.vertexIndex = cornerTableRow.getVertexIndex();
        this.oppositeCornerIndex = cornerTableRow.getOppositeCornerIndex();
    }

    /**
     * returns vertex of corner
     *
     * @return vertex
     */
    public int getVertexIndex() {
        return vertexIndex;
    }

    /**
     * @return index of opposite corner
     */
    public int getOppositeCornerIndex() {
        return oppositeCornerIndex;
    }

    /**
     * sets index of the opposite corner
     *
     * @param index index of the opposite corner in corner table
     */
    public void setOppositeCornerIndex(int index) {
        this.oppositeCornerIndex = index;
    }
}
