package cz.fidentis.analyst.mesh.core;

import java.util.ArrayList;
import java.util.List;
/**
 * 
 * @author Matej Lukeš
 */

public class MeshFacet {
    private List<MeshPoint> vertices = new ArrayList<>();
    private CornerTable cornerTable = new CornerTable();

    /**
     * Constructor of MeshFacet
     */
    public MeshFacet() {
        cornerTable = new CornerTable();
    }

    /**
     * Copy constructor of MeshFacet
     *
     * @param facet copied MeshFacet
     */
    public MeshFacet(MeshFacet facet) {
        for (MeshPoint vertex :
                facet.vertices) {
            vertices.add(new MeshPoint(vertex));
        }
        cornerTable = new CornerTable(facet.cornerTable);
    }


    public MeshPoint getVertex(int c) {
        return vertices.get(c);
    } // vertex of c

    public void addVertex(MeshPoint point){
        vertices.add(point);
    }

    public int getNumberOfVertices() {
        return vertices.size();
    }

    public CornerTable getCornerTable() {
        return cornerTable;
    }
    
    public List<MeshPoint> getVertices(){
        return vertices;
    }
    
}
