package cz.fidentis.analyst.mesh.core;

/**
 *
 * @author Matej Lukeš
 */
public class CornerTableRow {
    private int oppositeCornerIndex;
    private int vertexIndex;

    public CornerTableRow(int vertexIndex, int oppositeCornerIndex) {
        this.vertexIndex = vertexIndex;
        this.oppositeCornerIndex = oppositeCornerIndex;
    }
    /**
     * Copy constructor of a row in corner
     *
     * @param cornerTableRow copied row
     */
    public CornerTableRow(CornerTableRow cornerTableRow) {
        this.vertexIndex = cornerTableRow.getVertexIndex();
        this.oppositeCornerIndex = cornerTableRow.getOppositeCornerIndex();
    }


    /**
     * returns vertex of corner
     *
     * @return vertex
     */
    public int getVertexIndex() {
        return vertexIndex;
    }

    /**
     * @return index of opposite corner
     */
    public int getOppositeCornerIndex() {
        return oppositeCornerIndex;
    }

    public void setOppositeCornerIndex(int index) {
        this.oppositeCornerIndex = index;
    }
}
