/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui.tab;

import cz.fidentis.analyst.animator.Direction;
import cz.fidentis.analyst.gui.RegistrationCPEventListener;
import cz.fidentis.analyst.animator.ModelRotationAnimator;
import java.awt.Color;
import javax.swing.JColorChooser;

/**
 *
 * @author Richard Pajersky
 */
public class PostRegistrationCP extends javax.swing.JPanel {

    private RegistrationCPEventListener listener;
    private final ModelRotationAnimator animator = new ModelRotationAnimator();
    
    /**
     * Creates new form PostRegistrationPanel
     */
    public void initPostRegistrationCP(RegistrationCPEventListener listener) {
        initComponents();
        this.listener = listener;
        setDefaults();
    }
    
    private void setDefaults() {
        //transparencySlider.setMaximum(2 * listener.getTransparencyRange());
        //transparencySlider.setValue(listener.getTransparencyRange());
        primaryColorPanel.setBackground(listener.defaultPrimaryColor);
        secondaryColorPanel.setBackground(listener.defaultSecondaryColor);
        primaryFillRB.setSelected(true);
        secondaryFillRB.setSelected(true);
        highPrecisionRB.setSelected(true);
        thersholdFTF.setValue(listener.getFeaturePointsThreshold());
        resetAllButtonActionPerformed(null);
    }
    
    public void transform(Direction dir) {
        double newValue;
        switch (dir) {
            case TRANSLATE_LEFT:
                newValue = ((Number)translationXFTF.getValue()).doubleValue() - listener.getMoveModifier();
                translationXFTF.setValue(newValue);
                break;
            case TRANSLATE_RIGHT:
                newValue = ((Number)translationXFTF.getValue()).doubleValue() + listener.getMoveModifier();
                translationXFTF.setValue(newValue);
                break;
            case TRANSLATE_UP:
                newValue = ((Number)translationYFTF.getValue()).doubleValue() - listener.getMoveModifier();
                translationYFTF.setValue(newValue);
                break;
            case TRANSLATE_DOWN:
                newValue = ((Number)translationYFTF.getValue()).doubleValue() + listener.getMoveModifier();
                translationYFTF.setValue(newValue);
                break;
            case TRANSLATE_IN:
                newValue = ((Number)translationZFTF.getValue()).doubleValue() - listener.getMoveModifier();
                translationZFTF.setValue(newValue);
                break;
            case TRANSLATE_OUT:
                newValue = ((Number)translationZFTF.getValue()).doubleValue() + listener.getMoveModifier();
                translationZFTF.setValue(newValue);
                break;
            case ROTATE_LEFT:
                newValue = ((Number)rotationXFTF.getValue()).doubleValue() - listener.getMoveModifier();
                rotationXFTF.setValue(newValue);
                break;
            case ROTATE_RIGHT:
                newValue = ((Number)rotationXFTF.getValue()).doubleValue() + listener.getMoveModifier();
                rotationXFTF.setValue(newValue);
                break;
            case ROTATE_UP:
                newValue = ((Number)rotationYFTF.getValue()).doubleValue() - listener.getMoveModifier();
                rotationYFTF.setValue(newValue);
                break;
            case ROTATE_DOWN:
                newValue = ((Number)rotationYFTF.getValue()).doubleValue() + listener.getMoveModifier();
                rotationYFTF.setValue(newValue);
                break;
            case ROTATE_IN:
                newValue = ((Number)rotationZFTF.getValue()).doubleValue() - listener.getMoveModifier();
                rotationZFTF.setValue(newValue);
                break;
            case ROTATE_OUT:
                newValue = ((Number)rotationZFTF.getValue()).doubleValue() + listener.getMoveModifier();
                rotationZFTF.setValue(newValue);
                break;
            case ZOOM_OUT:
                newValue = ((Number)scaleFTF.getValue()).doubleValue() - listener.getMoveModifier();
                scaleFTF.setValue(newValue);
                break;
            case ZOOM_IN:
                newValue = ((Number)scaleFTF.getValue()).doubleValue() + listener.getMoveModifier();
                scaleFTF.setValue(newValue);
                break;
            default:
                throw new UnsupportedOperationException();
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        primaryRenderModeGroup = new javax.swing.ButtonGroup();
        secondaryRenerModeGroup = new javax.swing.ButtonGroup();
        precisionGroup = new javax.swing.ButtonGroup();
        registrationAdjustmentLabel = new javax.swing.JLabel();
        jSeparator11 = new javax.swing.JSeparator();
        visualizationPanel = new javax.swing.JPanel();
        jSeparator8 = new javax.swing.JSeparator();
        jSeparator4 = new javax.swing.JSeparator();
        visualizationLabel = new javax.swing.JLabel();
        jSeparator1 = new javax.swing.JSeparator();
        modelPanel = new javax.swing.JPanel();
        modelLabel = new javax.swing.JLabel();
        pointsLabel = new javax.swing.JLabel();
        transparencyButton = new javax.swing.JButton();
        linesLabel = new javax.swing.JLabel();
        colorButton = new javax.swing.JButton();
        fillLabel = new javax.swing.JLabel();
        renderModeLabel = new javax.swing.JLabel();
        secondaryHighlightsCB = new javax.swing.JCheckBox();
        primaryHighlightsCB = new javax.swing.JCheckBox();
        highlightsLabel = new javax.swing.JLabel();
        primaryLabel = new javax.swing.JLabel();
        secondaryLabel = new javax.swing.JLabel();
        transparencySlider = new javax.swing.JSlider();
        secondaryColorPanel = new javax.swing.JPanel();
        primaryColorPanel = new javax.swing.JPanel();
        primaryLinesRB = new javax.swing.JRadioButton();
        secondaryFillRB = new javax.swing.JRadioButton();
        primaryPointsRB = new javax.swing.JRadioButton();
        secondaryPointsRB = new javax.swing.JRadioButton();
        secondaryLinesRB = new javax.swing.JRadioButton();
        primaryFillRB = new javax.swing.JRadioButton();
        viewPanel = new javax.swing.JPanel();
        profileButton = new javax.swing.JButton();
        frontButton = new javax.swing.JButton();
        viewLabel = new javax.swing.JLabel();
        featurePointsPanel = new javax.swing.JPanel();
        featurePointsButton = new javax.swing.JToggleButton();
        thresholdDownButton = new javax.swing.JButton();
        thersholdUpButton = new javax.swing.JButton();
        thersholdButton = new javax.swing.JButton();
        thersholdFTF = new javax.swing.JFormattedTextField();
        featurePointsLabel = new javax.swing.JLabel();
        jSeparator3 = new javax.swing.JSeparator();
        transformationPanel = new javax.swing.JPanel();
        transformationLabel = new javax.swing.JLabel();
        jSeparator2 = new javax.swing.JSeparator();
        jSeparator6 = new javax.swing.JSeparator();
        translationPanel = new javax.swing.JPanel();
        translationButton = new javax.swing.JButton();
        jLabel2 = new javax.swing.JLabel();
        rightTranslationXButton = new javax.swing.JButton();
        translationXFTF = new javax.swing.JFormattedTextField();
        leftTranslationYButton = new javax.swing.JButton();
        translationYFTF = new javax.swing.JFormattedTextField();
        rightTranslationYButton = new javax.swing.JButton();
        translXLabel = new javax.swing.JLabel();
        translationZFTF = new javax.swing.JFormattedTextField();
        translZLabel = new javax.swing.JLabel();
        translYLabel = new javax.swing.JLabel();
        rightTranslationZButton = new javax.swing.JButton();
        leftTranslationXButton = new javax.swing.JButton();
        leftTranslationZButton = new javax.swing.JButton();
        rotationPanel = new javax.swing.JPanel();
        leftRotationYButton = new javax.swing.JButton();
        leftRotationXButton = new javax.swing.JButton();
        rotatZLabel = new javax.swing.JLabel();
        rotatYLabel = new javax.swing.JLabel();
        rotatXLabel = new javax.swing.JLabel();
        rotationButton = new javax.swing.JButton();
        rotationZFTF = new javax.swing.JFormattedTextField();
        rotationYFTF = new javax.swing.JFormattedTextField();
        rightRotationZButton = new javax.swing.JButton();
        rightRotationYButton = new javax.swing.JButton();
        leftRotationZButton = new javax.swing.JButton();
        rightRotationXButton = new javax.swing.JButton();
        rotationXFTF = new javax.swing.JFormattedTextField();
        jLabel3 = new javax.swing.JLabel();
        scalePanel = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        scalePlusButton = new javax.swing.JButton();
        scaleMinusButton = new javax.swing.JButton();
        scaleFTF = new javax.swing.JFormattedTextField();
        scaleButton = new javax.swing.JButton();
        resetAllButton = new javax.swing.JButton();
        jSeparator7 = new javax.swing.JSeparator();
        jSeparator9 = new javax.swing.JSeparator();
        precisionPanel = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        highPrecisionRB = new javax.swing.JRadioButton();
        lowPrecisionRB = new javax.swing.JRadioButton();
        jSeparator10 = new javax.swing.JSeparator();
        applyButton = new javax.swing.JButton();
        jSeparator5 = new javax.swing.JSeparator();

        setBackground(new java.awt.Color(176, 230, 226));
        setPreferredSize(new java.awt.Dimension(400, 630));

        registrationAdjustmentLabel.setFont(new java.awt.Font("Tahoma", 1, 14)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(registrationAdjustmentLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.registrationAdjustmentLabel.text")); // NOI18N

        visualizationPanel.setBackground(new java.awt.Color(176, 230, 226));

        visualizationLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(visualizationLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.visualizationLabel.text")); // NOI18N

        modelPanel.setBackground(new java.awt.Color(176, 230, 226));

        modelLabel.setFont(new java.awt.Font("Tahoma", 3, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(modelLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.modelLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(pointsLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.pointsLabel.text")); // NOI18N

        transparencyButton.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(transparencyButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.transparencyButton.text")); // NOI18N
        transparencyButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.transparencyButton.toolTipText")); // NOI18N
        transparencyButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        transparencyButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        transparencyButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        transparencyButton.setOpaque(false);
        transparencyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                transparencyButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(linesLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.linesLabel.text")); // NOI18N

        colorButton.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(colorButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.colorButton.text")); // NOI18N
        colorButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.colorButton.toolTipText")); // NOI18N
        colorButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        colorButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        colorButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        colorButton.setIconTextGap(0);
        colorButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        colorButton.setOpaque(false);
        colorButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(fillLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.fillLabel.text")); // NOI18N

        renderModeLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(renderModeLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.renderModeLabel.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(secondaryHighlightsCB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.secondaryHighlightsCB.text")); // NOI18N
        secondaryHighlightsCB.setOpaque(false);
        secondaryHighlightsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secondaryHighlightsCBActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(primaryHighlightsCB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.primaryHighlightsCB.text")); // NOI18N
        primaryHighlightsCB.setOpaque(false);
        primaryHighlightsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                primaryHighlightsCBActionPerformed(evt);
            }
        });

        highlightsLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(highlightsLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.highlightsLabel.text")); // NOI18N

        primaryLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(primaryLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.primaryLabel.text")); // NOI18N

        secondaryLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(secondaryLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.secondaryLabel.text")); // NOI18N
        secondaryLabel.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.secondaryLabel.toolTipText")); // NOI18N

        transparencySlider.setMajorTickSpacing(5);
        transparencySlider.setMaximum(20);
        transparencySlider.setMinorTickSpacing(5);
        transparencySlider.setOrientation(javax.swing.JSlider.VERTICAL);
        transparencySlider.setPaintTicks(true);
        transparencySlider.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.transparencySlider.toolTipText")); // NOI18N
        transparencySlider.setValue(10);
        transparencySlider.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        transparencySlider.setOpaque(false);
        transparencySlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                transparencySliderStateChanged(evt);
            }
        });

        secondaryColorPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        secondaryColorPanel.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.secondaryColorPanel.toolTipText")); // NOI18N
        secondaryColorPanel.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        secondaryColorPanel.setPreferredSize(new java.awt.Dimension(70, 14));
        secondaryColorPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                secondaryColorPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout secondaryColorPanelLayout = new javax.swing.GroupLayout(secondaryColorPanel);
        secondaryColorPanel.setLayout(secondaryColorPanelLayout);
        secondaryColorPanelLayout.setHorizontalGroup(
            secondaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 48, Short.MAX_VALUE)
        );
        secondaryColorPanelLayout.setVerticalGroup(
            secondaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 12, Short.MAX_VALUE)
        );

        primaryColorPanel.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        primaryColorPanel.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.primaryColorPanel.toolTipText")); // NOI18N
        primaryColorPanel.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        primaryColorPanel.setPreferredSize(new java.awt.Dimension(72, 14));
        primaryColorPanel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                primaryColorPanelMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout primaryColorPanelLayout = new javax.swing.GroupLayout(primaryColorPanel);
        primaryColorPanel.setLayout(primaryColorPanelLayout);
        primaryColorPanelLayout.setHorizontalGroup(
            primaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 48, Short.MAX_VALUE)
        );
        primaryColorPanelLayout.setVerticalGroup(
            primaryColorPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 12, Short.MAX_VALUE)
        );

        primaryRenderModeGroup.add(primaryLinesRB);
        org.openide.awt.Mnemonics.setLocalizedText(primaryLinesRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.primaryLinesRB.text")); // NOI18N
        primaryLinesRB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        primaryLinesRB.setOpaque(false);
        primaryLinesRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                primaryLinesRBActionPerformed(evt);
            }
        });

        secondaryRenerModeGroup.add(secondaryFillRB);
        org.openide.awt.Mnemonics.setLocalizedText(secondaryFillRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.secondaryFillRB.text")); // NOI18N
        secondaryFillRB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        secondaryFillRB.setOpaque(false);
        secondaryFillRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secondaryFillRBActionPerformed(evt);
            }
        });

        primaryRenderModeGroup.add(primaryPointsRB);
        org.openide.awt.Mnemonics.setLocalizedText(primaryPointsRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.primaryPointsRB.text")); // NOI18N
        primaryPointsRB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        primaryPointsRB.setOpaque(false);
        primaryPointsRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                primaryPointsRBActionPerformed(evt);
            }
        });

        secondaryRenerModeGroup.add(secondaryPointsRB);
        org.openide.awt.Mnemonics.setLocalizedText(secondaryPointsRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.secondaryPointsRB.text")); // NOI18N
        secondaryPointsRB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        secondaryPointsRB.setOpaque(false);
        secondaryPointsRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secondaryPointsRBActionPerformed(evt);
            }
        });

        secondaryRenerModeGroup.add(secondaryLinesRB);
        org.openide.awt.Mnemonics.setLocalizedText(secondaryLinesRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.secondaryLinesRB.text")); // NOI18N
        secondaryLinesRB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        secondaryLinesRB.setOpaque(false);
        secondaryLinesRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                secondaryLinesRBActionPerformed(evt);
            }
        });

        primaryRenderModeGroup.add(primaryFillRB);
        org.openide.awt.Mnemonics.setLocalizedText(primaryFillRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.primaryFillRB.text")); // NOI18N
        primaryFillRB.setMargin(new java.awt.Insets(0, 0, 0, 0));
        primaryFillRB.setOpaque(false);
        primaryFillRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                primaryFillRBActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout modelPanelLayout = new javax.swing.GroupLayout(modelPanel);
        modelPanel.setLayout(modelPanelLayout);
        modelPanelLayout.setHorizontalGroup(
            modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(modelPanelLayout.createSequentialGroup()
                .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(primaryLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 58, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(modelLabel)
                    .addComponent(secondaryLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 66, Short.MAX_VALUE))
                .addGap(18, 18, 18)
                .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(modelPanelLayout.createSequentialGroup()
                        .addComponent(colorButton, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(highlightsLabel)
                        .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(modelPanelLayout.createSequentialGroup()
                                .addGap(41, 41, 41)
                                .addComponent(linesLabel)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(pointsLabel))
                            .addGroup(modelPanelLayout.createSequentialGroup()
                                .addGap(18, 18, 18)
                                .addComponent(renderModeLabel)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 21, Short.MAX_VALUE)
                                .addComponent(transparencyButton, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(modelPanelLayout.createSequentialGroup()
                        .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(primaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(secondaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(18, 18, 18)
                        .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(primaryHighlightsCB)
                            .addComponent(secondaryHighlightsCB))
                        .addGap(28, 28, 28)
                        .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(modelPanelLayout.createSequentialGroup()
                                .addComponent(secondaryFillRB)
                                .addGap(18, 18, 18)
                                .addComponent(secondaryLinesRB)
                                .addGap(18, 18, 18)
                                .addComponent(secondaryPointsRB))
                            .addGroup(modelPanelLayout.createSequentialGroup()
                                .addComponent(primaryFillRB)
                                .addGap(18, 18, 18)
                                .addComponent(primaryLinesRB)
                                .addGap(18, 18, 18)
                                .addComponent(primaryPointsRB))
                            .addComponent(fillLabel))
                        .addGap(25, 25, 25)
                        .addComponent(transparencySlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        modelPanelLayout.setVerticalGroup(
            modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(modelPanelLayout.createSequentialGroup()
                .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(modelLabel)
                    .addGroup(modelPanelLayout.createSequentialGroup()
                        .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(highlightsLabel)
                            .addComponent(renderModeLabel)
                            .addComponent(transparencyButton)
                            .addComponent(colorButton))
                        .addGap(4, 4, 4)
                        .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(fillLabel)
                            .addComponent(linesLabel)
                            .addComponent(pointsLabel))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, modelPanelLayout.createSequentialGroup()
                            .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(primaryLabel)
                                .addComponent(primaryHighlightsCB))
                            .addGap(11, 11, 11)
                            .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(secondaryLabel, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(secondaryHighlightsCB, javax.swing.GroupLayout.Alignment.TRAILING)))
                        .addGroup(modelPanelLayout.createSequentialGroup()
                            .addComponent(primaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(secondaryColorPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, modelPanelLayout.createSequentialGroup()
                            .addComponent(primaryFillRB)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(secondaryFillRB))
                        .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, modelPanelLayout.createSequentialGroup()
                            .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(primaryLinesRB)
                                .addComponent(primaryPointsRB))
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addGroup(modelPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addComponent(secondaryLinesRB, javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(secondaryPointsRB, javax.swing.GroupLayout.Alignment.TRAILING)))
                        .addComponent(transparencySlider, javax.swing.GroupLayout.PREFERRED_SIZE, 53, javax.swing.GroupLayout.PREFERRED_SIZE))))
        );

        viewPanel.setBackground(new java.awt.Color(176, 230, 226));

        org.openide.awt.Mnemonics.setLocalizedText(profileButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.profileButton.text")); // NOI18N
        profileButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.profileButton.toolTipText")); // NOI18N
        profileButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        profileButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        profileButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        profileButton.setOpaque(false);
        profileButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                profileButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(frontButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.frontButton.text")); // NOI18N
        frontButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.frontButton.toolTipText")); // NOI18N
        frontButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        frontButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        frontButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        frontButton.setOpaque(false);
        frontButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                frontButtonActionPerformed(evt);
            }
        });

        viewLabel.setFont(new java.awt.Font("Tahoma", 3, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(viewLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.viewLabel.text")); // NOI18N

        javax.swing.GroupLayout viewPanelLayout = new javax.swing.GroupLayout(viewPanel);
        viewPanel.setLayout(viewPanelLayout);
        viewPanelLayout.setHorizontalGroup(
            viewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(viewPanelLayout.createSequentialGroup()
                .addComponent(viewLabel)
                .addGap(18, 18, 18)
                .addComponent(frontButton, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(profileButton, javax.swing.GroupLayout.PREFERRED_SIZE, 50, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        viewPanelLayout.setVerticalGroup(
            viewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(viewPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(viewLabel)
                .addComponent(frontButton)
                .addComponent(profileButton))
        );

        featurePointsPanel.setBackground(new java.awt.Color(176, 230, 226));

        org.openide.awt.Mnemonics.setLocalizedText(featurePointsButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.featurePointsButton.text")); // NOI18N
        featurePointsButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        featurePointsButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        featurePointsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                featurePointsButtonActionPerformed(evt);
            }
        });

        thresholdDownButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/subtract-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(thresholdDownButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.thresholdDownButton.text")); // NOI18N
        thresholdDownButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        thresholdDownButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        thresholdDownButton.setEnabled(false);
        thresholdDownButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        thresholdDownButton.setMaximumSize(new java.awt.Dimension(24, 24));
        thresholdDownButton.setMinimumSize(new java.awt.Dimension(24, 24));
        thresholdDownButton.setOpaque(false);
        thresholdDownButton.setPreferredSize(new java.awt.Dimension(24, 24));
        thresholdDownButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                thresholdDownButtonActionPerformed(evt);
            }
        });

        thersholdUpButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/add-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(thersholdUpButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.thersholdUpButton.text")); // NOI18N
        thersholdUpButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        thersholdUpButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        thersholdUpButton.setEnabled(false);
        thersholdUpButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        thersholdUpButton.setMaximumSize(new java.awt.Dimension(24, 24));
        thersholdUpButton.setMinimumSize(new java.awt.Dimension(24, 24));
        thersholdUpButton.setPreferredSize(new java.awt.Dimension(24, 24));
        thersholdUpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                thersholdUpButtonActionPerformed(evt);
            }
        });

        thersholdButton.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(thersholdButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.thersholdButton.text")); // NOI18N
        thersholdButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        thersholdButton.setEnabled(false);
        thersholdButton.setOpaque(false);
        thersholdButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                thersholdButtonActionPerformed(evt);
            }
        });

        thersholdFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        thersholdFTF.setEnabled(false);
        thersholdFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                thersholdFTFPropertyChange(evt);
            }
        });

        featurePointsLabel.setFont(new java.awt.Font("Tahoma", 3, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(featurePointsLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.featurePointsLabel.text")); // NOI18N

        javax.swing.GroupLayout featurePointsPanelLayout = new javax.swing.GroupLayout(featurePointsPanel);
        featurePointsPanel.setLayout(featurePointsPanelLayout);
        featurePointsPanelLayout.setHorizontalGroup(
            featurePointsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(featurePointsPanelLayout.createSequentialGroup()
                .addComponent(featurePointsLabel)
                .addGap(18, 18, 18)
                .addComponent(featurePointsButton, javax.swing.GroupLayout.PREFERRED_SIZE, 43, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(thersholdButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(thersholdFTF, javax.swing.GroupLayout.PREFERRED_SIZE, 70, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(thersholdUpButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(thresholdDownButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        featurePointsPanelLayout.setVerticalGroup(
            featurePointsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(featurePointsPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                .addComponent(featurePointsLabel)
                .addComponent(featurePointsButton)
                .addComponent(thersholdButton)
                .addComponent(thersholdFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
            .addComponent(thersholdUpButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(thresholdDownButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        );

        javax.swing.GroupLayout visualizationPanelLayout = new javax.swing.GroupLayout(visualizationPanel);
        visualizationPanel.setLayout(visualizationPanelLayout);
        visualizationPanelLayout.setHorizontalGroup(
            visualizationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(visualizationPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(visualizationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(visualizationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                        .addComponent(jSeparator1, javax.swing.GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE)
                        .addComponent(jSeparator4)
                        .addComponent(jSeparator8)
                        .addComponent(visualizationLabel))
                    .addComponent(modelPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(viewPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(featurePointsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addComponent(jSeparator3)
        );
        visualizationPanelLayout.setVerticalGroup(
            visualizationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, visualizationPanelLayout.createSequentialGroup()
                .addComponent(visualizationLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jSeparator4, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(modelPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator8, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(viewPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator1, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(featurePointsPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator3, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(19, 19, 19))
        );

        transformationPanel.setBackground(new java.awt.Color(176, 230, 226));
        transformationPanel.setPreferredSize(new java.awt.Dimension(400, 400));

        transformationLabel.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(transformationLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.transformationLabel.text")); // NOI18N

        translationPanel.setBackground(new java.awt.Color(176, 230, 226));

        translationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/restart-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(translationButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.translationButton.text")); // NOI18N
        translationButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.translationButton.toolTipText")); // NOI18N
        translationButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        translationButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        translationButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        translationButton.setOpaque(false);
        translationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                translationButtonActionPerformed(evt);
            }
        });

        jLabel2.setFont(new java.awt.Font("Tahoma", 3, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.jLabel2.text")); // NOI18N

        rightTranslationXButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-right-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rightTranslationXButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rightTranslationXButton.text")); // NOI18N
        rightTranslationXButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        rightTranslationXButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        rightTranslationXButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        rightTranslationXButton.setMaximumSize(new java.awt.Dimension(24, 24));
        rightTranslationXButton.setMinimumSize(new java.awt.Dimension(24, 24));
        rightTranslationXButton.setOpaque(false);
        rightTranslationXButton.setPreferredSize(new java.awt.Dimension(24, 24));
        rightTranslationXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightTranslationXButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightTranslationXButtonMouseReleased(evt);
            }
        });

        translationXFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        translationXFTF.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.translationXFTF.toolTipText")); // NOI18N
        translationXFTF.setCursor(new java.awt.Cursor(java.awt.Cursor.TEXT_CURSOR));
        translationXFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                translationXFTFPropertyChange(evt);
            }
        });

        leftTranslationYButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-left-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(leftTranslationYButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.leftTranslationYButton.text")); // NOI18N
        leftTranslationYButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        leftTranslationYButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        leftTranslationYButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        leftTranslationYButton.setOpaque(false);
        leftTranslationYButton.setPreferredSize(new java.awt.Dimension(24, 24));
        leftTranslationYButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                leftTranslationYButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                leftTranslationYButtonMouseReleased(evt);
            }
        });

        translationYFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        translationYFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                translationYFTFPropertyChange(evt);
            }
        });

        rightTranslationYButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-right-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rightTranslationYButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rightTranslationYButton.text")); // NOI18N
        rightTranslationYButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        rightTranslationYButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        rightTranslationYButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        rightTranslationYButton.setOpaque(false);
        rightTranslationYButton.setPreferredSize(new java.awt.Dimension(24, 24));
        rightTranslationYButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightTranslationYButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightTranslationYButtonMouseReleased(evt);
            }
        });

        translXLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(translXLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.translXLabel.text")); // NOI18N

        translationZFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        translationZFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                translationZFTFPropertyChange(evt);
            }
        });

        translZLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(translZLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.translZLabel.text")); // NOI18N

        translYLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(translYLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.translYLabel.text")); // NOI18N

        rightTranslationZButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-right-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rightTranslationZButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rightTranslationZButton.text")); // NOI18N
        rightTranslationZButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        rightTranslationZButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        rightTranslationZButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        rightTranslationZButton.setOpaque(false);
        rightTranslationZButton.setPreferredSize(new java.awt.Dimension(24, 24));
        rightTranslationZButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightTranslationZButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightTranslationZButtonMouseReleased(evt);
            }
        });

        leftTranslationXButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-left-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(leftTranslationXButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.leftTranslationXButton.text")); // NOI18N
        leftTranslationXButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        leftTranslationXButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        leftTranslationXButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        leftTranslationXButton.setMaximumSize(new java.awt.Dimension(24, 24));
        leftTranslationXButton.setMinimumSize(new java.awt.Dimension(24, 24));
        leftTranslationXButton.setOpaque(false);
        leftTranslationXButton.setPreferredSize(new java.awt.Dimension(24, 24));
        leftTranslationXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                leftTranslationXButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                leftTranslationXButtonMouseReleased(evt);
            }
        });

        leftTranslationZButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-left-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(leftTranslationZButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.leftTranslationZButton.text")); // NOI18N
        leftTranslationZButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        leftTranslationZButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        leftTranslationZButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        leftTranslationZButton.setOpaque(false);
        leftTranslationZButton.setPreferredSize(new java.awt.Dimension(24, 24));
        leftTranslationZButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                leftTranslationZButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                leftTranslationZButtonMouseReleased(evt);
            }
        });

        javax.swing.GroupLayout translationPanelLayout = new javax.swing.GroupLayout(translationPanel);
        translationPanel.setLayout(translationPanelLayout);
        translationPanelLayout.setHorizontalGroup(
            translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(translationPanelLayout.createSequentialGroup()
                .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(translationPanelLayout.createSequentialGroup()
                        .addComponent(jLabel2)
                        .addGap(28, 28, 28))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, translationPanelLayout.createSequentialGroup()
                        .addComponent(translationButton)
                        .addGap(18, 18, 18)))
                .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(translXLabel)
                    .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(translationXFTF, javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(javax.swing.GroupLayout.Alignment.LEADING, translationPanelLayout.createSequentialGroup()
                            .addComponent(leftTranslationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                            .addComponent(rightTranslationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addGap(18, 18, 18)
                .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(translationPanelLayout.createSequentialGroup()
                        .addComponent(leftTranslationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rightTranslationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(translYLabel)
                    .addComponent(translationYFTF, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(translationPanelLayout.createSequentialGroup()
                        .addComponent(leftTranslationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rightTranslationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(translationZFTF, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(translZLabel))
                .addContainerGap(14, Short.MAX_VALUE))
        );
        translationPanelLayout.setVerticalGroup(
            translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(translationPanelLayout.createSequentialGroup()
                .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(translXLabel)
                        .addComponent(translYLabel)
                        .addComponent(translZLabel))
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(translationPanelLayout.createSequentialGroup()
                        .addComponent(rightTranslationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(translationPanelLayout.createSequentialGroup()
                        .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(leftTranslationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(rightTranslationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addGroup(translationPanelLayout.createSequentialGroup()
                                    .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(leftTranslationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(rightTranslationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addGroup(translationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(translationXFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(translationYFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(translationZFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addComponent(translationButton))
                            .addComponent(leftTranslationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
        );

        rotationPanel.setBackground(new java.awt.Color(176, 230, 226));

        leftRotationYButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-left-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(leftRotationYButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.leftRotationYButton.text")); // NOI18N
        leftRotationYButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        leftRotationYButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        leftRotationYButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        leftRotationYButton.setMaximumSize(new java.awt.Dimension(24, 24));
        leftRotationYButton.setMinimumSize(new java.awt.Dimension(24, 24));
        leftRotationYButton.setOpaque(false);
        leftRotationYButton.setPreferredSize(new java.awt.Dimension(24, 24));
        leftRotationYButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                leftRotationYButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                leftRotationYButtonMouseReleased(evt);
            }
        });

        leftRotationXButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-left-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(leftRotationXButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.leftRotationXButton.text")); // NOI18N
        leftRotationXButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        leftRotationXButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        leftRotationXButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        leftRotationXButton.setOpaque(false);
        leftRotationXButton.setPreferredSize(new java.awt.Dimension(24, 24));
        leftRotationXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                leftRotationXButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                leftRotationXButtonMouseReleased(evt);
            }
        });

        rotatZLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rotatZLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rotatZLabel.text")); // NOI18N

        rotatYLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rotatYLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rotatYLabel.text")); // NOI18N

        rotatXLabel.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rotatXLabel, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rotatXLabel.text")); // NOI18N

        rotationButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/restart-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rotationButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rotationButton.text")); // NOI18N
        rotationButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rotationButton.toolTipText")); // NOI18N
        rotationButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        rotationButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        rotationButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        rotationButton.setOpaque(false);
        rotationButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rotationButtonActionPerformed(evt);
            }
        });

        rotationZFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        rotationZFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                rotationZFTFPropertyChange(evt);
            }
        });

        rotationYFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        rotationYFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                rotationYFTFPropertyChange(evt);
            }
        });

        rightRotationZButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-right-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rightRotationZButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rightRotationZButton.text")); // NOI18N
        rightRotationZButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        rightRotationZButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        rightRotationZButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        rightRotationZButton.setMaximumSize(new java.awt.Dimension(24, 24));
        rightRotationZButton.setMinimumSize(new java.awt.Dimension(24, 24));
        rightRotationZButton.setOpaque(false);
        rightRotationZButton.setPreferredSize(new java.awt.Dimension(24, 24));
        rightRotationZButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightRotationZButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightRotationZButtonMouseReleased(evt);
            }
        });

        rightRotationYButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-right-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rightRotationYButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rightRotationYButton.text")); // NOI18N
        rightRotationYButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        rightRotationYButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        rightRotationYButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        rightRotationYButton.setMaximumSize(new java.awt.Dimension(24, 24));
        rightRotationYButton.setMinimumSize(new java.awt.Dimension(24, 24));
        rightRotationYButton.setOpaque(false);
        rightRotationYButton.setPreferredSize(new java.awt.Dimension(24, 24));
        rightRotationYButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightRotationYButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightRotationYButtonMouseReleased(evt);
            }
        });

        leftRotationZButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-left-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(leftRotationZButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.leftRotationZButton.text")); // NOI18N
        leftRotationZButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        leftRotationZButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        leftRotationZButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        leftRotationZButton.setMaximumSize(new java.awt.Dimension(24, 24));
        leftRotationZButton.setMinimumSize(new java.awt.Dimension(24, 24));
        leftRotationZButton.setOpaque(false);
        leftRotationZButton.setPreferredSize(new java.awt.Dimension(24, 24));
        leftRotationZButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                leftRotationZButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                leftRotationZButtonMouseReleased(evt);
            }
        });

        rightRotationXButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/arrow-right-s-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(rightRotationXButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rightRotationXButton.text")); // NOI18N
        rightRotationXButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        rightRotationXButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        rightRotationXButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        rightRotationXButton.setMaximumSize(new java.awt.Dimension(24, 24));
        rightRotationXButton.setMinimumSize(new java.awt.Dimension(24, 24));
        rightRotationXButton.setOpaque(false);
        rightRotationXButton.setPreferredSize(new java.awt.Dimension(24, 24));
        rightRotationXButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                rightRotationXButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                rightRotationXButtonMouseReleased(evt);
            }
        });

        rotationXFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        rotationXFTF.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.rotationXFTF.toolTipText")); // NOI18N
        rotationXFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                rotationXFTFPropertyChange(evt);
            }
        });

        jLabel3.setFont(new java.awt.Font("Tahoma", 3, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.jLabel3.text")); // NOI18N

        javax.swing.GroupLayout rotationPanelLayout = new javax.swing.GroupLayout(rotationPanel);
        rotationPanel.setLayout(rotationPanelLayout);
        rotationPanelLayout.setHorizontalGroup(
            rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(rotationPanelLayout.createSequentialGroup()
                .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(rotationPanelLayout.createSequentialGroup()
                        .addGap(48, 48, 48)
                        .addComponent(rotationButton))
                    .addComponent(jLabel3))
                .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(rotationPanelLayout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(rotatXLabel)
                            .addGroup(rotationPanelLayout.createSequentialGroup()
                                .addComponent(leftRotationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(rightRotationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, rotationPanelLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rotationXFTF, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(21, 21, 21)
                .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(rotationPanelLayout.createSequentialGroup()
                        .addComponent(leftRotationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(rightRotationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(rotationYFTF, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(rotatYLabel))
                .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(rotationPanelLayout.createSequentialGroup()
                        .addGap(22, 22, 22)
                        .addComponent(rotatZLabel))
                    .addGroup(rotationPanelLayout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(rotationZFTF, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(rotationPanelLayout.createSequentialGroup()
                                .addComponent(leftRotationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(rightRotationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        rotationPanelLayout.setVerticalGroup(
            rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(rotationPanelLayout.createSequentialGroup()
                .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(rotatXLabel)
                        .addComponent(jLabel3))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(rotatYLabel)
                        .addComponent(rotatZLabel)))
                .addGap(6, 6, 6)
                .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(rotationButton)
                    .addGroup(rotationPanelLayout.createSequentialGroup()
                        .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(rightRotationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(leftRotationYButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(leftRotationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(rightRotationXButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(leftRotationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(rightRotationZButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(rotationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(rotationYFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(rotationXFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(rotationZFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        scalePanel.setBackground(new java.awt.Color(176, 230, 226));

        jLabel4.setFont(new java.awt.Font("Tahoma", 3, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.jLabel4.text")); // NOI18N

        scalePlusButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/add-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(scalePlusButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.scalePlusButton.text")); // NOI18N
        scalePlusButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        scalePlusButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        scalePlusButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        scalePlusButton.setMaximumSize(new java.awt.Dimension(24, 24));
        scalePlusButton.setMinimumSize(new java.awt.Dimension(24, 24));
        scalePlusButton.setOpaque(false);
        scalePlusButton.setPreferredSize(new java.awt.Dimension(24, 24));
        scalePlusButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                scalePlusButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                scalePlusButtonMouseReleased(evt);
            }
        });

        scaleMinusButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/subtract-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(scaleMinusButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.scaleMinusButton.text")); // NOI18N
        scaleMinusButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        scaleMinusButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        scaleMinusButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        scaleMinusButton.setMaximumSize(new java.awt.Dimension(24, 24));
        scaleMinusButton.setMinimumSize(new java.awt.Dimension(24, 24));
        scaleMinusButton.setOpaque(false);
        scaleMinusButton.setPreferredSize(new java.awt.Dimension(24, 24));
        scaleMinusButton.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mousePressed(java.awt.event.MouseEvent evt) {
                scaleMinusButtonMousePressed(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                scaleMinusButtonMouseReleased(evt);
            }
        });

        scaleFTF.setFormatterFactory(new javax.swing.text.DefaultFormatterFactory(new javax.swing.text.NumberFormatter()));
        scaleFTF.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.scaleFTF.toolTipText")); // NOI18N
        scaleFTF.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                scaleFTFPropertyChange(evt);
            }
        });

        scaleButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/restart-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(scaleButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.scaleButton.text")); // NOI18N
        scaleButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.scaleButton.toolTipText")); // NOI18N
        scaleButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        scaleButton.setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        scaleButton.setMargin(new java.awt.Insets(2, 2, 2, 2));
        scaleButton.setOpaque(false);
        scaleButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                scaleButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout scalePanelLayout = new javax.swing.GroupLayout(scalePanel);
        scalePanel.setLayout(scalePanelLayout);
        scalePanelLayout.setHorizontalGroup(
            scalePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, scalePanelLayout.createSequentialGroup()
                .addGroup(scalePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(scalePanelLayout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addGap(0, 42, Short.MAX_VALUE))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, scalePanelLayout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(scaleButton)))
                .addGap(18, 18, 18)
                .addGroup(scalePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, scalePanelLayout.createSequentialGroup()
                        .addComponent(scalePlusButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(scaleMinusButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(scaleFTF, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, 54, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
        scalePanelLayout.setVerticalGroup(
            scalePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(scalePanelLayout.createSequentialGroup()
                .addGap(1, 1, 1)
                .addComponent(jLabel4)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(scaleButton))
            .addGroup(scalePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(scalePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(scaleMinusButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(scalePlusButton, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(scaleFTF, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        resetAllButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/refresh-line.png"))); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(resetAllButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.resetAllButton.text")); // NOI18N
        resetAllButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.resetAllButton.toolTipText")); // NOI18N
        resetAllButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        resetAllButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                resetAllButtonActionPerformed(evt);
            }
        });

        jSeparator9.setOrientation(javax.swing.SwingConstants.VERTICAL);

        precisionPanel.setBackground(new java.awt.Color(176, 230, 226));

        jLabel5.setFont(new java.awt.Font("Tahoma", 1, 11)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(jLabel5, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.jLabel5.text")); // NOI18N

        precisionGroup.add(highPrecisionRB);
        org.openide.awt.Mnemonics.setLocalizedText(highPrecisionRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.highPrecisionRB.text")); // NOI18N
        highPrecisionRB.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.highPrecisionRB.toolTipText")); // NOI18N
        highPrecisionRB.setOpaque(false);
        highPrecisionRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                highPrecisionRBActionPerformed(evt);
            }
        });

        precisionGroup.add(lowPrecisionRB);
        org.openide.awt.Mnemonics.setLocalizedText(lowPrecisionRB, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.lowPrecisionRB.text")); // NOI18N
        lowPrecisionRB.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.lowPrecisionRB.toolTipText")); // NOI18N
        lowPrecisionRB.setOpaque(false);
        lowPrecisionRB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lowPrecisionRBActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout precisionPanelLayout = new javax.swing.GroupLayout(precisionPanel);
        precisionPanel.setLayout(precisionPanelLayout);
        precisionPanelLayout.setHorizontalGroup(
            precisionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(precisionPanelLayout.createSequentialGroup()
                .addGroup(precisionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel5)
                    .addComponent(highPrecisionRB)
                    .addComponent(lowPrecisionRB))
                .addGap(0, 8, Short.MAX_VALUE))
        );
        precisionPanelLayout.setVerticalGroup(
            precisionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(precisionPanelLayout.createSequentialGroup()
                .addComponent(jLabel5)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(highPrecisionRB)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lowPrecisionRB)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jSeparator10.setOrientation(javax.swing.SwingConstants.VERTICAL);

        org.openide.awt.Mnemonics.setLocalizedText(applyButton, org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.applyButton.text")); // NOI18N
        applyButton.setToolTipText(org.openide.util.NbBundle.getMessage(PostRegistrationCP.class, "PostRegistrationCP.applyButton.toolTipText")); // NOI18N
        applyButton.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        applyButton.setCursor(new java.awt.Cursor(java.awt.Cursor.HAND_CURSOR));
        applyButton.setMargin(new java.awt.Insets(0, 0, 0, 0));
        applyButton.setOpaque(false);
        applyButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                applyButtonActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout transformationPanelLayout = new javax.swing.GroupLayout(transformationPanel);
        transformationPanel.setLayout(transformationPanelLayout);
        transformationPanelLayout.setHorizontalGroup(
            transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(transformationPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(rotationPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(transformationPanelLayout.createSequentialGroup()
                        .addGroup(transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                .addComponent(transformationLabel)
                                .addComponent(jSeparator6, javax.swing.GroupLayout.DEFAULT_SIZE, 371, Short.MAX_VALUE)
                                .addComponent(jSeparator2))
                            .addComponent(translationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSeparator7, javax.swing.GroupLayout.PREFERRED_SIZE, 371, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(transformationPanelLayout.createSequentialGroup()
                                .addComponent(scalePanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jSeparator9, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addComponent(precisionPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jSeparator10, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(resetAllButton, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(applyButton, javax.swing.GroupLayout.PREFERRED_SIZE, 83, javax.swing.GroupLayout.PREFERRED_SIZE))))
                        .addGap(0, 9, Short.MAX_VALUE)))
                .addContainerGap())
            .addComponent(jSeparator5, javax.swing.GroupLayout.Alignment.TRAILING)
        );
        transformationPanelLayout.setVerticalGroup(
            transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(transformationPanelLayout.createSequentialGroup()
                .addComponent(transformationLabel)
                .addGap(13, 13, 13)
                .addComponent(jSeparator2, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(1, 1, 1)
                .addComponent(translationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator6, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(rotationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator7, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(transformationPanelLayout.createSequentialGroup()
                        .addGroup(transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(applyButton, javax.swing.GroupLayout.PREFERRED_SIZE, 27, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSeparator10, javax.swing.GroupLayout.PREFERRED_SIZE, 62, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(transformationPanelLayout.createSequentialGroup()
                        .addGroup(transformationPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(transformationPanelLayout.createSequentialGroup()
                                .addComponent(scalePanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGap(7, 7, 7))
                            .addComponent(jSeparator9, javax.swing.GroupLayout.PREFERRED_SIZE, 62, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(precisionPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(resetAllButton))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 9, Short.MAX_VALUE)))
                .addComponent(jSeparator5, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jSeparator11)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(registrationAdjustmentLabel))
            .addComponent(transformationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addComponent(visualizationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 387, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(registrationAdjustmentLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSeparator11, javax.swing.GroupLayout.PREFERRED_SIZE, 10, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(visualizationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 247, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(10, 10, 10)
                .addComponent(transformationPanel, javax.swing.GroupLayout.PREFERRED_SIZE, 333, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(39, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void primaryColorPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_primaryColorPanelMouseClicked
        if (transparencySlider.getValue() == 0) {
            return;
        }
        Color current = primaryColorPanel.getBackground();
        Color newColor = JColorChooser.showDialog(null, "Choose a color", current);
            if (newColor != null) {
            primaryColorPanel.setBackground(newColor);
            listener.setPrimaryColor(newColor);
        }
    }//GEN-LAST:event_primaryColorPanelMouseClicked

    private void secondaryColorPanelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_secondaryColorPanelMouseClicked
        if (transparencySlider.getValue() == 2*listener.transparencyRange) {
            return;
        }
        Color current = secondaryColorPanel.getBackground();
        Color newColor = JColorChooser.showDialog(null, "Choose a color", current);
        if (newColor != null) {
            secondaryColorPanel.setBackground(newColor);
            listener.setSecondaryColor(newColor);
        }
    }//GEN-LAST:event_secondaryColorPanelMouseClicked

    private void transparencyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_transparencyButtonActionPerformed
        transparencySlider.setValue(10);
        transparencySlider.repaint();
        listener.setTransparency(10);
    }//GEN-LAST:event_transparencyButtonActionPerformed

    private void transparencySliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_transparencySliderStateChanged
        int transparency = transparencySlider.getValue();
        if (transparency == 0) {
            primaryColorPanel.setBackground(Color.lightGray);
            primaryHighlightsCB.setEnabled(false);
            primaryHighlightsCB.setEnabled(false);
            primaryFillRB.setEnabled(false);
            primaryLinesRB.setEnabled(false);
            primaryPointsRB.setEnabled(false);
        } else if (transparency == 2*listener.transparencyRange) {
            secondaryColorPanel.setBackground(Color.lightGray);
            secondaryHighlightsCB.setEnabled(false);
            secondaryHighlightsCB.setEnabled(false);
            secondaryFillRB.setEnabled(false);
            secondaryLinesRB.setEnabled(false);
            secondaryPointsRB.setEnabled(false);
        } else if (!primaryFillRB.isEnabled()) {
            primaryColorPanel.setBackground(listener.getPrimaryColor());
            primaryHighlightsCB.setEnabled(true);
            primaryHighlightsCB.setEnabled(true);
            primaryFillRB.setEnabled(true);
            primaryLinesRB.setEnabled(true);
            primaryPointsRB.setEnabled(true);
        } else if (!secondaryFillRB.isEnabled()) {
            secondaryColorPanel.setBackground(listener.getSecondaryColor());
            secondaryHighlightsCB.setEnabled(true);
            secondaryHighlightsCB.setEnabled(true);
            secondaryFillRB.setEnabled(true);
            secondaryLinesRB.setEnabled(true);
            secondaryPointsRB.setEnabled(true);
        }
        listener.setTransparency(transparency);
    }//GEN-LAST:event_transparencySliderStateChanged

    private void frontButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_frontButtonActionPerformed
        listener.setFrontFacing();
    }//GEN-LAST:event_frontButtonActionPerformed

    private void profileButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_profileButtonActionPerformed
        listener.setSideFacing();
    }//GEN-LAST:event_profileButtonActionPerformed

    private void translationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_translationButtonActionPerformed
        translationXFTF.setValue(0);
        translationYFTF.setValue(0);
        translationZFTF.setValue(0);
        listener.resetTranslation();
    }//GEN-LAST:event_translationButtonActionPerformed

    private void rotationButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rotationButtonActionPerformed
        rotationXFTF.setValue(0);
        rotationYFTF.setValue(0);
        rotationZFTF.setValue(0);
        listener.resetRotation();
    }//GEN-LAST:event_rotationButtonActionPerformed

    private void scaleButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_scaleButtonActionPerformed
        scaleFTF.setValue(0);
        listener.resetScale();
    }//GEN-LAST:event_scaleButtonActionPerformed

    private void resetAllButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_resetAllButtonActionPerformed
        translationButtonActionPerformed(evt);
        rotationButtonActionPerformed(evt);
        scaleButtonActionPerformed(evt);
    }//GEN-LAST:event_resetAllButtonActionPerformed

    private void translationXFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_translationXFTFPropertyChange
        double value = ((Number)translationXFTF.getValue()).doubleValue();
        listener.setXTranslation(value);
    }//GEN-LAST:event_translationXFTFPropertyChange

    private void translationYFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_translationYFTFPropertyChange
        double value = ((Number)translationYFTF.getValue()).doubleValue();
        listener.setYTranslation(value);
    }//GEN-LAST:event_translationYFTFPropertyChange

    private void translationZFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_translationZFTFPropertyChange
        double value = ((Number)translationZFTF.getValue()).doubleValue();
        listener.setZTranslation(value);
    }//GEN-LAST:event_translationZFTFPropertyChange

    private void rotationXFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_rotationXFTFPropertyChange
        double value = ((Number)rotationXFTF.getValue()).doubleValue();
        listener.setXRotation(value);
    }//GEN-LAST:event_rotationXFTFPropertyChange

    private void rotationYFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_rotationYFTFPropertyChange
        double value = ((Number)rotationYFTF.getValue()).doubleValue();
        listener.setYRotation(value);
    }//GEN-LAST:event_rotationYFTFPropertyChange

    private void rotationZFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_rotationZFTFPropertyChange
        double value = ((Number)rotationZFTF.getValue()).doubleValue();
        listener.setZRotation(value);
    }//GEN-LAST:event_rotationZFTFPropertyChange

    private void scaleFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_scaleFTFPropertyChange
        double value = ((Number)scaleFTF.getValue()).doubleValue();
        listener.setScale(value);
    }//GEN-LAST:event_scaleFTFPropertyChange

    private void primaryHighlightsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_primaryHighlightsCBActionPerformed
        if (primaryHighlightsCB.isSelected())
            listener.setPrimaryHighlights();
        else
            listener.removePrimaryHighlights();
    }//GEN-LAST:event_primaryHighlightsCBActionPerformed

    private void secondaryHighlightsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secondaryHighlightsCBActionPerformed
        if (secondaryHighlightsCB.isSelected())
            listener.setSecondaryHighlights();
        else
            listener.removeSecondaryHighlights();
    }//GEN-LAST:event_secondaryHighlightsCBActionPerformed

    private void primaryFillRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_primaryFillRBActionPerformed
        listener.setPrimaryFill();
    }//GEN-LAST:event_primaryFillRBActionPerformed

    private void primaryLinesRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_primaryLinesRBActionPerformed
        listener.setPrimaryLines();
    }//GEN-LAST:event_primaryLinesRBActionPerformed

    private void primaryPointsRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_primaryPointsRBActionPerformed
        listener.setPrimaryPoints();
    }//GEN-LAST:event_primaryPointsRBActionPerformed

    private void secondaryFillRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secondaryFillRBActionPerformed
        listener.setSecondaryFill();
    }//GEN-LAST:event_secondaryFillRBActionPerformed

    private void secondaryLinesRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secondaryLinesRBActionPerformed
        listener.setSecondaryLines();
    }//GEN-LAST:event_secondaryLinesRBActionPerformed

    private void secondaryPointsRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_secondaryPointsRBActionPerformed
        listener.setSecondaryPoints();
    }//GEN-LAST:event_secondaryPointsRBActionPerformed

    private void colorButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorButtonActionPerformed
        primaryColorPanel.setBackground(listener.defaultPrimaryColor);
        secondaryColorPanel.setBackground(listener.defaultSecondaryColor);
        listener.setDeafultColor();
    }//GEN-LAST:event_colorButtonActionPerformed

    private void applyButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_applyButtonActionPerformed
        listener.transformFace();
        resetAllButtonActionPerformed(evt);
    }//GEN-LAST:event_applyButtonActionPerformed

    private void featurePointsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_featurePointsButtonActionPerformed
        if (listener.isFeaturePointsActive()) {
            featurePointsButton.setText("show");
            thersholdButton.setEnabled(false);
            thersholdFTF.setEnabled(false);
            thersholdUpButton.setEnabled(false);
            thresholdDownButton.setEnabled(false);
            listener.setFeaturePointsActive(false);
        } else {
            featurePointsButton.setText("hide");
            thersholdButton.setEnabled(true);
            thersholdFTF.setEnabled(true);
            thersholdUpButton.setEnabled(true);
            thresholdDownButton.setEnabled(true);
            listener.setFeaturePointsActive(true);
        }
    }//GEN-LAST:event_featurePointsButtonActionPerformed

    private void thersholdFTFPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_thersholdFTFPropertyChange
        listener.setFeaturePointsThreshold(((Number)thersholdFTF.getValue()).doubleValue());
    }//GEN-LAST:event_thersholdFTFPropertyChange

    private void leftTranslationXButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftTranslationXButtonMousePressed
        animator.startModelAnimation(Direction.TRANSLATE_LEFT, this);
    }//GEN-LAST:event_leftTranslationXButtonMousePressed

    private void leftTranslationXButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftTranslationXButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_leftTranslationXButtonMouseReleased

    private void rightTranslationXButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTranslationXButtonMousePressed
        animator.startModelAnimation(Direction.TRANSLATE_RIGHT, this);
    }//GEN-LAST:event_rightTranslationXButtonMousePressed

    private void rightTranslationXButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTranslationXButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_rightTranslationXButtonMouseReleased

    private void leftTranslationYButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftTranslationYButtonMousePressed
        animator.startModelAnimation(Direction.TRANSLATE_UP, this);
    }//GEN-LAST:event_leftTranslationYButtonMousePressed

    private void leftTranslationYButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftTranslationYButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_leftTranslationYButtonMouseReleased

    private void rightTranslationYButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTranslationYButtonMousePressed
        animator.startModelAnimation(Direction.TRANSLATE_DOWN, this);
    }//GEN-LAST:event_rightTranslationYButtonMousePressed

    private void rightTranslationYButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTranslationYButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_rightTranslationYButtonMouseReleased

    private void leftTranslationZButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftTranslationZButtonMousePressed
        animator.startModelAnimation(Direction.TRANSLATE_IN, this);
    }//GEN-LAST:event_leftTranslationZButtonMousePressed

    private void leftTranslationZButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftTranslationZButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_leftTranslationZButtonMouseReleased

    private void rightTranslationZButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTranslationZButtonMousePressed
        animator.startModelAnimation(Direction.TRANSLATE_OUT, this);
    }//GEN-LAST:event_rightTranslationZButtonMousePressed

    private void rightTranslationZButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightTranslationZButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_rightTranslationZButtonMouseReleased

    private void leftRotationXButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftRotationXButtonMousePressed
        animator.startModelAnimation(Direction.ROTATE_LEFT, this);
    }//GEN-LAST:event_leftRotationXButtonMousePressed

    private void leftRotationXButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftRotationXButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_leftRotationXButtonMouseReleased

    private void rightRotationXButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightRotationXButtonMousePressed
        animator.startModelAnimation(Direction.ROTATE_RIGHT, this);
    }//GEN-LAST:event_rightRotationXButtonMousePressed

    private void rightRotationXButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightRotationXButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_rightRotationXButtonMouseReleased

    private void leftRotationYButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftRotationYButtonMousePressed
        animator.startModelAnimation(Direction.ROTATE_UP, this);
    }//GEN-LAST:event_leftRotationYButtonMousePressed

    private void leftRotationYButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftRotationYButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_leftRotationYButtonMouseReleased

    private void rightRotationYButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightRotationYButtonMousePressed
        animator.startModelAnimation(Direction.ROTATE_DOWN, this);
    }//GEN-LAST:event_rightRotationYButtonMousePressed

    private void rightRotationYButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightRotationYButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_rightRotationYButtonMouseReleased

    private void leftRotationZButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftRotationZButtonMousePressed
        animator.startModelAnimation(Direction.ROTATE_IN, this);
    }//GEN-LAST:event_leftRotationZButtonMousePressed

    private void leftRotationZButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_leftRotationZButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_leftRotationZButtonMouseReleased

    private void rightRotationZButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightRotationZButtonMousePressed
        animator.startModelAnimation(Direction.ROTATE_OUT, this);
    }//GEN-LAST:event_rightRotationZButtonMousePressed

    private void rightRotationZButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rightRotationZButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_rightRotationZButtonMouseReleased

    private void scaleMinusButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_scaleMinusButtonMousePressed
        animator.startModelAnimation(Direction.ZOOM_OUT, this);
    }//GEN-LAST:event_scaleMinusButtonMousePressed

    private void scaleMinusButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_scaleMinusButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_scaleMinusButtonMouseReleased

    private void scalePlusButtonMousePressed(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_scalePlusButtonMousePressed
        animator.startModelAnimation(Direction.ZOOM_IN, this);
    }//GEN-LAST:event_scalePlusButtonMousePressed

    private void scalePlusButtonMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_scalePlusButtonMouseReleased
        animator.stopModelAnimation(this);
    }//GEN-LAST:event_scalePlusButtonMouseReleased

    private void thresholdDownButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_thresholdDownButtonActionPerformed
        double newValue = ((Number)thersholdFTF.getValue()).doubleValue() - 0.1;
        thersholdFTF.setValue(newValue);
    }//GEN-LAST:event_thresholdDownButtonActionPerformed

    private void thersholdUpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_thersholdUpButtonActionPerformed
        double newValue = ((Number)thersholdFTF.getValue()).doubleValue() + 0.1;
        thersholdFTF.setValue(newValue);
    }//GEN-LAST:event_thersholdUpButtonActionPerformed

    private void thersholdButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_thersholdButtonActionPerformed
        thersholdFTF.setValue(listener.getFeaturePointsThreshold());
    }//GEN-LAST:event_thersholdButtonActionPerformed

    private void highPrecisionRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_highPrecisionRBActionPerformed
        listener.setMoveModifier(listener.precisionQuotient);
    }//GEN-LAST:event_highPrecisionRBActionPerformed

    private void lowPrecisionRBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lowPrecisionRBActionPerformed
        listener.setMoveModifier(listener.baseQuotient);
    }//GEN-LAST:event_lowPrecisionRBActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton applyButton;
    private javax.swing.JButton colorButton;
    private javax.swing.JToggleButton featurePointsButton;
    private javax.swing.JLabel featurePointsLabel;
    private javax.swing.JPanel featurePointsPanel;
    private javax.swing.JLabel fillLabel;
    private javax.swing.JButton frontButton;
    private javax.swing.JRadioButton highPrecisionRB;
    private javax.swing.JLabel highlightsLabel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JSeparator jSeparator10;
    private javax.swing.JSeparator jSeparator11;
    private javax.swing.JSeparator jSeparator2;
    private javax.swing.JSeparator jSeparator3;
    private javax.swing.JSeparator jSeparator4;
    private javax.swing.JSeparator jSeparator5;
    private javax.swing.JSeparator jSeparator6;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JSeparator jSeparator9;
    private javax.swing.JButton leftRotationXButton;
    private javax.swing.JButton leftRotationYButton;
    private javax.swing.JButton leftRotationZButton;
    private javax.swing.JButton leftTranslationXButton;
    private javax.swing.JButton leftTranslationYButton;
    private javax.swing.JButton leftTranslationZButton;
    private javax.swing.JLabel linesLabel;
    private javax.swing.JRadioButton lowPrecisionRB;
    private javax.swing.JLabel modelLabel;
    private javax.swing.JPanel modelPanel;
    private javax.swing.JLabel pointsLabel;
    private javax.swing.ButtonGroup precisionGroup;
    private javax.swing.JPanel precisionPanel;
    private javax.swing.JPanel primaryColorPanel;
    private javax.swing.JRadioButton primaryFillRB;
    private javax.swing.JCheckBox primaryHighlightsCB;
    private javax.swing.JLabel primaryLabel;
    private javax.swing.JRadioButton primaryLinesRB;
    private javax.swing.JRadioButton primaryPointsRB;
    private javax.swing.ButtonGroup primaryRenderModeGroup;
    private javax.swing.JButton profileButton;
    private javax.swing.JLabel registrationAdjustmentLabel;
    private javax.swing.JLabel renderModeLabel;
    private javax.swing.JButton resetAllButton;
    private javax.swing.JButton rightRotationXButton;
    private javax.swing.JButton rightRotationYButton;
    private javax.swing.JButton rightRotationZButton;
    private javax.swing.JButton rightTranslationXButton;
    private javax.swing.JButton rightTranslationYButton;
    private javax.swing.JButton rightTranslationZButton;
    private javax.swing.JLabel rotatXLabel;
    private javax.swing.JLabel rotatYLabel;
    private javax.swing.JLabel rotatZLabel;
    private javax.swing.JButton rotationButton;
    private javax.swing.JPanel rotationPanel;
    private javax.swing.JFormattedTextField rotationXFTF;
    private javax.swing.JFormattedTextField rotationYFTF;
    private javax.swing.JFormattedTextField rotationZFTF;
    private javax.swing.JButton scaleButton;
    private javax.swing.JFormattedTextField scaleFTF;
    private javax.swing.JButton scaleMinusButton;
    private javax.swing.JPanel scalePanel;
    private javax.swing.JButton scalePlusButton;
    private javax.swing.JPanel secondaryColorPanel;
    private javax.swing.JRadioButton secondaryFillRB;
    private javax.swing.JCheckBox secondaryHighlightsCB;
    private javax.swing.JLabel secondaryLabel;
    private javax.swing.JRadioButton secondaryLinesRB;
    private javax.swing.JRadioButton secondaryPointsRB;
    private javax.swing.ButtonGroup secondaryRenerModeGroup;
    private javax.swing.JButton thersholdButton;
    private javax.swing.JFormattedTextField thersholdFTF;
    private javax.swing.JButton thersholdUpButton;
    private javax.swing.JButton thresholdDownButton;
    private javax.swing.JLabel transformationLabel;
    private javax.swing.JPanel transformationPanel;
    private javax.swing.JLabel translXLabel;
    private javax.swing.JLabel translYLabel;
    private javax.swing.JLabel translZLabel;
    private javax.swing.JButton translationButton;
    private javax.swing.JPanel translationPanel;
    private javax.swing.JFormattedTextField translationXFTF;
    private javax.swing.JFormattedTextField translationYFTF;
    private javax.swing.JFormattedTextField translationZFTF;
    private javax.swing.JButton transparencyButton;
    private javax.swing.JSlider transparencySlider;
    private javax.swing.JLabel viewLabel;
    private javax.swing.JPanel viewPanel;
    private javax.swing.JLabel visualizationLabel;
    private javax.swing.JPanel visualizationPanel;
    // End of variables declaration//GEN-END:variables
}
