/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.face.HumanFace;
import java.util.Observable;
import java.util.Observer;
import javax.swing.table.DefaultTableModel;

/**
 *
 * @author Matej Kovar
 */
public class ModelsTableModel extends DefaultTableModel implements Observer {
    
    /**
     * Constructor for table model
     * @param columnNames names of Columns
     * @param rowCount number of rows
     */
    public ModelsTableModel(Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
    }


    private Class[] types = new Class [] {
        java.lang.Boolean.class, java.lang.String.class, java.lang.Boolean.class
    };

    private boolean[] canEdit = new boolean [] {
        true, false, false
    };

    @Override
    public Class getColumnClass(int columnIndex) {
        return types [columnIndex];}

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return canEdit [columnIndex];
    }
    public Class[] getTypes() {
        return types;}

    public void setTypes(Class[] types) {
        this.types = types;}

    public boolean[] getCanEdit() {
        return canEdit;}

    public void setCanEdit(boolean[] canEdit) {
        this.canEdit = canEdit;
    }
    
    @Override
    public void update(Observable o, Object o1) {
        HumanFace face = (HumanFace)o1;
        String name = face.getShortName();
        boolean hasKD = false;
        if (face.getKdTree() != null) {
            hasKD = true;
        }
        for (int i = 0; i < getRowCount(); i++) {
            if (getValueAt(i, 1).equals(name)) {
                this.setValueAt(hasKD, i, 2);
                break;
            }
        }
    }
    
}
