package cz.fidentis.analyst.kdtree;

import java.util.concurrent.Callable;

/**
 *
 * @author Daniel Schramm
 */
public abstract class KdTreeVisitor implements Callable<KdTreeVisitor> {
    
    private final boolean concurrently;
    
    private KdTree kdTree;

    public KdTreeVisitor(boolean concurrently) {
        this.concurrently = concurrently;
    }
    
    public boolean isThreadSafe() {
        return true;
    }
    
    public boolean concurrently() {
        return this.concurrently && isThreadSafe();
    }
    
    protected abstract void visitKdTree(KdTree kdTree);
    
    public void visit(KdTree kdTree) {
        if (concurrently && isThreadSafe()) {
            this.kdTree = kdTree;
        } else {
            visitKdTree(kdTree);
        }
    }
    
    @Override
    public KdTreeVisitor call() throws Exception {
        visitKdTree(kdTree);
        return this;
    }
}
