package cz.fidentis.analyst.filter;

import cz.fidentis.analyst.core.ProgressDialog;
import cz.fidentis.analyst.project.ModelsTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingWorker;

/**
 * A task that filters table and selects models which should be removed
 * 
 * @author Matej Kovar
 */
public class FilterTask extends SwingWorker<Boolean, Integer>{
    
    private final FilterPanel filterPanel;
    private ModelsTableModel model;
    private final ProgressDialog progressDialog;
    
    private boolean completed = false;
    
    private List<Integer> filteredRows = new ArrayList<>();
    
    /**
     * Constructor
     * 
     * @param model ModelsTableModel
     * @param filterPanel FilterPanel
     * @param progressDialog ProgressDialog
     */
    public FilterTask(ModelsTableModel model, FilterPanel filterPanel, ProgressDialog progressDialog) {

        this.filterPanel = filterPanel;
        this.model = model;
        this.progressDialog = progressDialog;
    }

    @Override
    protected Boolean doInBackground() throws Exception {
        
        filteredRows.clear();
        
        // Selects only models from list which are not filtered yet (are not in the bottom of list)
        for (int row = 0; row < model.getRowCount() - filterPanel.getFilterHistory().getTotalFaces(); row++) { 
            
            if (isCancelled()) {
                completed = false;
                filteredRows.clear();
                return false;
            }

            String faceName = model.getValueAt(row, 1).toString();
            if (filterPanel.applyFilterOptions(faceName)) {

                filteredRows.add(row);
            }
            
            int progress = (int)Math.round(100.0 * (row + 1) / model.getRowCount());
            progressDialog.setValue(progress);
        }
        
        completed = true;
        return true;
    }
    
    @Override
    protected void done() {
        progressDialog.dispose();
        
        if (isCancelled()) {
            completed = false;
            filteredRows.clear();
            return;
        }
        completed = true;
    }
    
    public boolean getCompleted() {
        return completed;
    }

    public List<Integer> getFilteredRows() {
        return filteredRows;
    }
    
}
