package cz.fidentis.analyst.featurepoints;

import cz.fidentis.analyst.core.ControlPanel;
import cz.fidentis.analyst.drawables.DrawableFeaturePoints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;

/**
 *
 * @author Katerina Zarska
 */
public class FeaturePointsPanel extends ControlPanel {

    /*
     * Mandatory design elements
     */
    public static final String ICON = "fps28x28.png";
    public static final String NAME = "Feature Points";
    
    private final ActionListener action;
    
    /*
     * Configuration of panel-specific GUI elements
     */
    public static final String ACTION_COMMAND_ADD_FEATURE_POINT = "add feature point";
    public static final String ACTION_COMMAND_REMOVE_FEATURE_POINT = "remove feature point";
    public static final String ACTION_COMMAND_EDIT_FEATURE_POINT = "edit feature point";
    public static final String ACTION_COMMAND_EXPORT_FEATURE_POINTS = "export feature points";
    public static final String ACTION_COMMAND_LOAD_FEATURE_POINTS = "load feature points";
    public static final String ACTION_CHANGE_DISTANCE_THRESHOLD = "change threshold for feature point";
    public static final String ACTION_PIN_SELECTED_FEATURE_POINTS = "pin highlighted feature points to mesh";
    public static final String ACTION_PIN_ALL_FEATURE_POINTS = "pin all feature points to mesh";

    /**
     * Creates new form FeaturePointsPanel
     */
    public FeaturePointsPanel(ActionListener action, DrawableFeaturePoints featurePoints) {
        setName(NAME);
        initComponents();
        this.action = action;
        featurePointListPanel.initComponents(action, featurePoints);
        addFpButton.addActionListener(createListener(action, ACTION_COMMAND_ADD_FEATURE_POINT));
        removeFpButton.addActionListener(createListener(action, ACTION_COMMAND_REMOVE_FEATURE_POINT));
        editFpButton.addActionListener(createListener(action, ACTION_COMMAND_EDIT_FEATURE_POINT));
        pinSelectedFpButton.addActionListener(createListener(action, ACTION_PIN_SELECTED_FEATURE_POINTS));
        pinAllFpButton.addActionListener(createListener(action, ACTION_PIN_ALL_FEATURE_POINTS));
        resetSlider();
    }

    @Override
    public ImageIcon getIcon() {
        return getStaticIcon();
    }
    
    /**
     * Static implementation of the {@link #getIcon()} method.
     * 
     * @return Control panel icon
     */
    public static ImageIcon getStaticIcon() {
        return new ImageIcon(FeaturePointsPanel.class.getClassLoader().getResource("/" + ICON));
    }
    
    /**
     * Gets the FeaturePointListPanel
     * @return FeaturePointListPanel
     */
    public FeaturePointListPanel getFeaturePointListPanel() {
        return featurePointListPanel;
    }
    
    /**
     * Resets the slider into initial values
     */
    public void resetSlider() {
        thresholdSpinSlider.initDouble(0.01, 0.0, 0.2, 3);
        thresholdSpinSlider.addSpinnerListener(createListener(action, ACTION_CHANGE_DISTANCE_THRESHOLD));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        addFpButton = new javax.swing.JToggleButton();
        editFpButton = new javax.swing.JToggleButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        featurePointListPanel = new cz.fidentis.analyst.featurepoints.FeaturePointListPanel();
        removeFpButton = new javax.swing.JButton();
        thresholdSpinSlider = new cz.fidentis.analyst.core.SpinSlider();
        pinSelectedFpButton = new javax.swing.JButton();
        pinAllFpButton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(addFpButton, org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.addFpButton.text")); // NOI18N
        addFpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                addFpButtonActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(editFpButton, org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.editFpButton.text")); // NOI18N
        editFpButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editFpButtonActionPerformed(evt);
            }
        });

        featurePointListPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(null, org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.featurePointListPanel.border.title"), javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Segoe UI", 1, 12))); // NOI18N

        javax.swing.GroupLayout featurePointListPanelLayout = new javax.swing.GroupLayout(featurePointListPanel);
        featurePointListPanel.setLayout(featurePointListPanelLayout);
        featurePointListPanelLayout.setHorizontalGroup(
            featurePointListPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 532, Short.MAX_VALUE)
        );
        featurePointListPanelLayout.setVerticalGroup(
            featurePointListPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 367, Short.MAX_VALUE)
        );

        jScrollPane1.setViewportView(featurePointListPanel);

        removeFpButton.setLabel(org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.removeFpButton.label")); // NOI18N

        thresholdSpinSlider.setToolTipText(org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.thresholdSpinSlider.toolTipText")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(pinSelectedFpButton, org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.pinSelectedFpButton.text_2")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(pinAllFpButton, org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.pinAllFpButton.text_2")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.jLabel1.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(thresholdSpinSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(addFpButton, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(removeFpButton, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(editFpButton, javax.swing.GroupLayout.PREFERRED_SIZE, 90, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(pinSelectedFpButton)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(pinAllFpButton))
                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                .addContainerGap(212, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 250, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(addFpButton)
                    .addComponent(editFpButton)
                    .addComponent(removeFpButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addGap(4, 4, 4)
                .addComponent(thresholdSpinSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(pinAllFpButton)
                    .addComponent(pinSelectedFpButton))
                .addContainerGap(210, Short.MAX_VALUE))
        );

        thresholdSpinSlider.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FeaturePointsPanel.class, "FeaturePointsPanel.thresholdSpinSlider.AccessibleContext.accessibleName")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void addFpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_addFpButtonActionPerformed
        this.addFpButton.setSelected(true);
        this.editFpButton.setSelected(false);
    }//GEN-LAST:event_addFpButtonActionPerformed

    private void editFpButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editFpButtonActionPerformed
        this.addFpButton.setSelected(false);
        this.editFpButton.setSelected(true);
    }//GEN-LAST:event_editFpButtonActionPerformed

    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JToggleButton addFpButton;
    private javax.swing.JToggleButton editFpButton;
    private cz.fidentis.analyst.featurepoints.FeaturePointListPanel featurePointListPanel;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JButton pinAllFpButton;
    private javax.swing.JButton pinSelectedFpButton;
    private javax.swing.JButton removeFpButton;
    private cz.fidentis.analyst.core.SpinSlider thresholdSpinSlider;
    // End of variables declaration//GEN-END:variables
}
