/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.gui;

import cz.fidentis.analyst.gui.canvas.Canvas;
import cz.fidentis.analyst.gui.scene.DrawableMesh;
import cz.fidentis.analyst.visitors.mesh.BoundingBox;
import java.awt.Color;
import java.util.ArrayList;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

/**
 * Executes changes made in PostRegistrationCP
 * 
 * @author Richard Pajersky
 */
public class RegistrationCPEventListener {
    
    private final Canvas canvas;
    private final Color defaultPrimaryColor = new Color(51, 51, 153);
    private final Color defaultSecondaryColor = new Color(255, 239, 0);
    private final int transparencyRange = 10;
    private final float changeAmount = 500f;
    private final float moveX;
    private final float moveY;
    private final float moveZ;
    private final float scaleXYZ;
    
    private DrawableMesh primaryFace;
    private DrawableMesh secondaryFace;
    
    public RegistrationCPEventListener(Canvas canvas) {
        this.canvas = canvas;
        
        ArrayList<DrawableMesh> drawables = new ArrayList<>(canvas.getScene().getDrawables());
        primaryFace = drawables.get(0);
        secondaryFace = drawables.get(1);
        setDeafultColor();
        
        // set change amounts
        BoundingBox visitor = new BoundingBox();
        secondaryFace.getModel().compute(visitor);
        Point3d maxPoint = visitor.getBoundingBox().getMaxPoint();
        Point3d minPoint = visitor.getBoundingBox().getMaxPoint();
        moveX = (float) (maxPoint.x - minPoint.x) / changeAmount;
        moveY = (float) (maxPoint.y - minPoint.y) / changeAmount;
        moveZ = (float) (maxPoint.z - minPoint.z) / changeAmount;
        scaleXYZ = (float) (visitor.getBoundingBox().getMaxDiag() / (10 * changeAmount));
    }
    
    public final void setDeafultColor() {
        primaryFace.setColor(defaultPrimaryColor);
        secondaryFace.setColor(defaultSecondaryColor);
    }
    
    public int getTransparencyRange() {
        return transparencyRange;
    }
    
    public void setPrimaryColor(Color color) {
        primaryFace.setColor(color);
        canvas.renderScene();
    }

    public void setSecondaryColor(Color color) {
        secondaryFace.setColor(color);
        canvas.renderScene();
    }
    
    public Color getPrimaryColor() {
        return primaryFace.getColor();
    }

    public Color getSecondaryColor() {
        return secondaryFace.getColor();
    }
    
    public void setTransparency(int value) {
        int range = this.transparencyRange;
        if (value == range) {
            setPrimaryTransparency(1f);
            setSecondaryTransparency(1f);
        }
        if (value < range) {
            setPrimaryTransparency(value / range);
            setSecondaryTransparency(1f);
        }
        if (value > range) {
            setSecondaryTransparency((2 * range - value) / range);
            setPrimaryTransparency(1f);
        }
        canvas.renderScene();
    }
    
    public void setPrimaryTransparency(float transparency) {
        primaryFace.setTransparency(transparency);
    }

    public void setSecondaryTransparency(float transparency) {
        secondaryFace.setTransparency(transparency);
    }
    
    public float getPrimaryTransparency() {
        return primaryFace.getTransparency();
    }

    public float getSecondaryTransparency() {
        return secondaryFace.getTransparency();
    }
    
    public void setFrontFacing() {
        canvas.getCamera().initLocation();
        canvas.renderScene();
    }
    
    public void setSideFacing() {
        canvas.getCamera().initLocation();
        canvas.getCamera().rotate(0, 90);
        canvas.renderScene();
    }
    
    public Color getDefaultPrimaryColor() {
        return defaultPrimaryColor;
    }

    public Color getDefaultSecondaryColor() {
        return defaultSecondaryColor;
    }
    
    public void resetTranslation() {
        secondaryFace.setTranslation(new Vector3f(0, 0, 0));
        canvas.renderScene();
    }
    
    public void resetRotation() {
        secondaryFace.setRotation(new Vector3f(0, 0, 0));
        canvas.renderScene();
    }

    public void resetScale() {
        secondaryFace.setScale(new Vector3f(0, 0, 0));
        canvas.renderScene();
    }
    
    public void setXTranslation(float value) {
        secondaryFace.getTranslation().x = value * moveX;
        canvas.renderScene();
    }
    
    public void setYTranslation(float value) {
        secondaryFace.getTranslation().y = value * moveY;
        canvas.renderScene();
    }
        
    public void setZTranslation(float value) {
        secondaryFace.getTranslation().z = value * moveZ;
        canvas.renderScene();
    }
    
    public void setXRotation(float value) {
        secondaryFace.getRotation().x = value * moveX;
        canvas.renderScene();
    }
    
    public void setYRotation(float value) {
        secondaryFace.getRotation().y = value * moveY;
        canvas.renderScene();
    }
        
    public void setZRotation(float value) {
        secondaryFace.getRotation().z = value * moveZ;
        canvas.renderScene();
    }
    
    public void setScale(float value) {
        secondaryFace.getScale().x = value * scaleXYZ;
        secondaryFace.getScale().y = value * scaleXYZ;
        secondaryFace.getScale().z = value * scaleXYZ;
        canvas.renderScene();
    }
}
