/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.feature.services;

import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.exception.FeaturePointException;
import cz.fidentis.analyst.feature.provider.FeaturePointTypeProvider;
import cz.fidentis.analyst.feature.utils.FileResourcesUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

/**
 *
 * @author kubok
 */
public class FeaturePointImportExportService {

    private static final String COLUMN_DELIMETER = ",";
    private static final String CODE_PREFIX_DELIMETER = " ";

    public static List<FeaturePoint> importFeaturePoints(String path, String fileName) {
        FileResourcesUtils app = new FileResourcesUtils();
        try (InputStreamReader streamReader
                = new InputStreamReader(app.getFileAsStream(path, fileName), StandardCharsets.UTF_8);
                BufferedReader reader = new BufferedReader(streamReader)) {

            Stream<String> lines = reader.lines();
            List<List<String>> linesList = new ArrayList<>();

            lines
                    .forEach(line -> {
                        linesList.add(Arrays.asList(line.split(COLUMN_DELIMETER)));
                    });

            if (linesList.size() != 2
                    || linesList.get(0).size() != linesList.get(1).size()) {
                throw new FeaturePointException(String.format("Feature point import file '%s' has wrong format", fileName));
            }

            List<FeaturePoint> points = new ArrayList<>();
            for (int i = 1; i < linesList.get(0).size(); i += 3) {
                FeaturePoint point = new FeaturePoint(
                        Double.parseDouble(linesList.get(1).get(i)),
                        Double.parseDouble(linesList.get(1).get(i + 1)),
                        Double.parseDouble(linesList.get(1).get(i + 2)),
                        FeaturePointTypeProvider.getInstance().getFeaturePointTypeByCode(
                                getCode(linesList.get(0).get(i)))
                );
                points.add(point);
            }
            return points;

        } catch (IOException e) {
            throw new FeaturePointException(String.format("Feature point cannot open file", fileName));
        } catch (NumberFormatException e1) {
            throw new FeaturePointException(e1.getMessage());
        }
    }

    private static String getCode(String str) {
        return str.substring(0, str.indexOf(CODE_PREFIX_DELIMETER));
    }

    public static void exportFeaturePoints(List<FeaturePoint> featurePointList, String objectName) throws FileNotFoundException, IOException {
        File csvOutputFile = new File(String.format("%s_landmarks.csv", objectName));
        // CSV is a normal text file, need a writer
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(csvOutputFile))) {
            bw.write("Scan name");
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.write(String.format(",%s x", featurePoint.getFeaturePointType().getCode()));
                    bw.write(String.format(",%s y", featurePoint.getFeaturePointType().getCode()));
                    bw.write(String.format(",%s z", featurePoint.getFeaturePointType().getCode()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointImportExportService.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            bw.newLine();
            bw.write(String.format("%s", objectName));
            featurePointList.forEach(featurePoint -> {
                try {
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getX()));
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getY()));
                    bw.write(",");
                    bw.write(Double.toString(featurePoint.getZ()));
                } catch (IOException ex) {
                    Logger.getLogger(FeaturePointImportExportService.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
        }
    }

}
