/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.core;

import org.netbeans.api.settings.ConvertAsProperties;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.windows.TopComponent;
import org.openide.util.NbBundle.Messages;
import cz.fidentis.analyst.Project;
import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.face.HumanFaceFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.openide.filesystems.FileChooserBuilder;

/**
 * The main panel enabling analysts to select the primary and secondary faces,
 * and to perform basic batch processing. This panel also serves as an entry
 * point for detailed face analysis and face-to-face comparison.
 *
 * @author Matej Kovar
 */
@ConvertAsProperties(
        dtd = "-//cz.fidentis.analyst.gui//Dashboard//EN",
        autostore = false
)
@TopComponent.Description(
        preferredID = "ProjectTopComp",
        //iconBase="SET/PATH/TO/ICON/HERE",
        persistenceType = TopComponent.PERSISTENCE_ALWAYS
)
@TopComponent.Registration(mode = "editor", openAtStartup = true)
@ActionID(category = "Window", id = "cz.fidentis.analyst.gui.ProjectTopComp")
@ActionReference(path = "Menu/Window" /*, position = 333 */)
@TopComponent.OpenActionRegistration(
        displayName = "#CTL_ProjectTopCompAction",
        preferredID = "ProjectTopComp"
)
@Messages({
    "CTL_ProjectTopCompAction=Project",
    "CTL_ProjectTopCompTopComponent=Project",
    "HINT_ProjectTopCompTopComponent=This is a Project window"
})
public final class ProjectTopComp extends TopComponent {

    private final Project project;
    private Map<HumanFace, SingleFaceTab> singleFaceTabs = new HashMap<>();
    private Map<HumanFace, FaceToFaceTab> faceToFaceTabs = new HashMap<>();
    private javax.swing.table.DefaultTableModel model;
    
    /* List of indexes of selected Rows */
    private List<Integer> selectedRows = new ArrayList<>();
    
    /* Variable which helps to see whether user has clicked to checkbox or
    clicked on selection buttons */
    private Boolean byUser = true;
    
    /**
     * Creates new ProjectTopComp, initializes new project
     */
    public ProjectTopComp() {
        project = new Project();
        initComponents();
        setName(Bundle.CTL_ProjectTopCompTopComponent());
        setToolTipText(Bundle.HINT_ProjectTopCompTopComponent());
        putClientProperty(TopComponent.PROP_CLOSING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_DRAGGING_DISABLED, Boolean.TRUE);
        putClientProperty(TopComponent.PROP_UNDOCKING_DISABLED, Boolean.TRUE);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanel1 = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        addButton1 = new javax.swing.JButton();
        removeButton1 = new javax.swing.JButton();
        selectAllButton1 = new javax.swing.JButton();
        deselectAllButton1 = new javax.swing.JButton();
        inflateButton1 = new javax.swing.JButton();
        oneOnOneButton1 = new javax.swing.JButton();
        analyseButton1 = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTable1 = new javax.swing.JTable();

        setLayout(new java.awt.BorderLayout());

        jPanel1.setPreferredSize(new java.awt.Dimension(0, 0));

        jPanel5.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel5.setLayout(new java.awt.GridBagLayout());

        addButton1.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(addButton1, org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.addButton1.text")); // NOI18N
        addButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                addButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(16, 16, 13, 4);
        jPanel5.add(addButton1, gridBagConstraints);

        removeButton1.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(removeButton1, org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.removeButton1.text")); // NOI18N
        removeButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                removeButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(16, 22, 13, 4);
        jPanel5.add(removeButton1, gridBagConstraints);

        selectAllButton1.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(selectAllButton1, org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.selectAllButton1.text")); // NOI18N
        selectAllButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                selectAllButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(16, 22, 13, 4);
        jPanel5.add(selectAllButton1, gridBagConstraints);

        deselectAllButton1.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(deselectAllButton1, org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.deselectAllButton1.text")); // NOI18N
        deselectAllButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                deselectAllButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(16, 22, 13, 4);
        jPanel5.add(deselectAllButton1, gridBagConstraints);

        inflateButton1.setFont(new java.awt.Font("Tahoma", 0, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(inflateButton1, org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.inflateButton1.text")); // NOI18N
        inflateButton1.setAlignmentX(0.5F);
        inflateButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                inflateButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(16, 22, 13, 4);
        jPanel5.add(inflateButton1, gridBagConstraints);

        oneOnOneButton1.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(oneOnOneButton1, org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.oneOnOneButton1.text")); // NOI18N
        oneOnOneButton1.setAlignmentX(0.5F);
        oneOnOneButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                oneOnOneButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(16, 55, 13, 4);
        jPanel5.add(oneOnOneButton1, gridBagConstraints);

        analyseButton1.setFont(new java.awt.Font("Tahoma", 1, 12)); // NOI18N
        org.openide.awt.Mnemonics.setLocalizedText(analyseButton1, org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.analyseButton1.text")); // NOI18N
        analyseButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                analyseButton1MouseClicked(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(16, 16, 13, 4);
        jPanel5.add(analyseButton1, gridBagConstraints);

        jTable1.setFont(new java.awt.Font("Tahoma", 0, 18)); // NOI18N
        jTable1.getTableHeader().setOpaque(false);
        jTable1.getTableHeader().setBackground(new java.awt.Color(204,204,204));
        jTable1.getTableHeader().setFont(new java.awt.Font("Tahoma", 0, 18));
        jTable1.setModel(new javax.swing.table.DefaultTableModel(
            new Object [][] {},
            new String [] {"", "Models"}) {
            private Class[] types = new Class [] {
                java.lang.Boolean.class, java.lang.Object.class
            };
            private boolean[] canEdit = new boolean [] {
                true, false};

            public Class getColumnClass(int columnIndex) {
                return types [columnIndex];}

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return canEdit [columnIndex];
            }
            public Class[] getTypes() {
                return types;}

            public void setTypes(Class[] types) {
                this.types = types;}

            public boolean[] getCanEdit() {
                return canEdit;}

            public void setCanEdit(boolean[] canEdit) {
                this.canEdit = canEdit;
            }
        });
        //javax.swing.table.DefaultTableModel model = (javax.swing.table.DefaultTableModel)jTable1.getModel();
        model = (javax.swing.table.DefaultTableModel) jTable1.getModel();
        model.addTableModelListener(new TableModelListener() {

            public void tableChanged(TableModelEvent e) {

                if (e.getType() == javax.swing.event.TableModelEvent.UPDATE && byUser) {
                    int row = e.getFirstRow();
                    int col = e.getColumn();

                    if (jTable1.getValueAt(row, col) == (Object)true) {
                        selectedRows.add(row);
                    } else {
                        selectedRows.remove((Object)row);
                    }
                }
            }
        });
        jTable1.setDragEnabled(true);
        jTable1.setRowHeight(40);
        jTable1.setRowSelectionAllowed(false);
        jTable1.getTableHeader().setReorderingAllowed(false);
        jScrollPane1.setViewportView(jTable1);
        jTable1.getColumnModel().getSelectionModel().setSelectionMode(javax.swing.ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        if (jTable1.getColumnModel().getColumnCount() > 0) {
            jTable1.getColumnModel().getColumn(0).setPreferredWidth(50);
            jTable1.getColumnModel().getColumn(0).setMaxWidth(50);
            jTable1.getColumnModel().getColumn(0).setHeaderValue(org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.jTable1.columnModel.title1_1")); // NOI18N
            jTable1.getColumnModel().getColumn(1).setHeaderValue(org.openide.util.NbBundle.getMessage(ProjectTopComp.class, "ProjectTopComp.jTable1.columnModel.title0_1")); // NOI18N
        }

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 782, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 0, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 760, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, 783, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 442, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jPanel5, javax.swing.GroupLayout.PREFERRED_SIZE, 56, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(jPanel1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    /**
     * Adds new model
     * @param evt starts function for loading model
     */
    private void addButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_addButton1MouseClicked
        loadModel();
    }//GEN-LAST:event_addButton1MouseClicked

    /**
     * Removes selected models from list and project
     * @param evt Removes selected faces
     */
    private void removeButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_removeButton1MouseClicked

        Collections.sort(selectedRows, Collections.reverseOrder());
        selectedRows.forEach(row -> {
            HumanFace face = this.project.getFaceByName(model.getValueAt(row, 1).toString());
            this.project.removeFace(face);
            model.removeRow(row);
        });
        selectedRows.clear();
    }//GEN-LAST:event_removeButton1MouseClicked
    
    /**
     * Opens 1:1 tab with two selected faces, otherwise pops message that you
     * should select two faces
     * @param evt 
     */
    private void oneOnOneButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_oneOnOneButton1MouseClicked
        //loadTwoModels();

        if (selectedRows.size() == 2) {

            String name1 = model.getValueAt(selectedRows.get(0), 1).toString();
            String name2 = model.getValueAt(selectedRows.get(1), 1).toString();
            HumanFace face1 = project.getFaceByName(name1);
            HumanFace face2 = project.getFaceByName(name2);
            createFaceToFaceTab(face1, face2, name1 + ":" + name2);
        } else {
            JOptionPane.showMessageDialog(this, "Select two models");
        }
    }//GEN-LAST:event_oneOnOneButton1MouseClicked

    /**
     * Selects all models from list of models
     * @param evt 
     */
    private void selectAllButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_selectAllButton1MouseClicked
        byUser = false;
        for (int i = 0; i < model.getRowCount(); i++) {
            model.setValueAt(true, i, 0);
        }
        selectedRows = IntStream.range(0, model.getRowCount()).boxed().collect(Collectors.toList());
        byUser = true;

    }//GEN-LAST:event_selectAllButton1MouseClicked

    /**
     * Deselects all models from list of models
     * @param evt 
     */
    private void deselectAllButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_deselectAllButton1MouseClicked
        byUser = false;
        selectedRows.forEach(i -> {
            model.setValueAt(false, i, 0);
        });
        selectedRows.clear();
        byUser = true;
    }//GEN-LAST:event_deselectAllButton1MouseClicked

    /**
     * Inflates models (selected will be deselected and vice versa)
     * @param evt 
     */
    private void inflateButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_inflateButton1MouseClicked
        byUser = false;
        for (int i = 0; i < model.getRowCount(); i++) {
            if (model.getValueAt(i, 0) == (Object) true) {
                model.setValueAt(false, i, 0);
            } else {
                model.setValueAt(true, i, 0);
            }
        }

        List<Integer> allRows = IntStream.range(0, model.getRowCount()).boxed().collect(Collectors.toList());
        allRows.removeAll(selectedRows);
        selectedRows = allRows;
        byUser = true;
    }//GEN-LAST:event_inflateButton1MouseClicked

    /**
     * Opens analysis of one selected face, otherwise pops message dialog that
     * you should select just one face
     * @param evt 
     */
    private void analyseButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_analyseButton1MouseClicked

        if (selectedRows.size() == 1) {

            String name = model.getValueAt(selectedRows.get(0), 1).toString();
            HumanFace face = project.getFaceByName(name);
            createSingleFaceTab(face, name);
        } else {
            JOptionPane.showMessageDialog(this, "Select one model");
        }

    }//GEN-LAST:event_analyseButton1MouseClicked

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton addButton1;
    private javax.swing.JButton analyseButton1;
    private javax.swing.JButton deselectAllButton1;
    private javax.swing.JButton inflateButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTable jTable1;
    private javax.swing.JButton oneOnOneButton1;
    private javax.swing.JButton removeButton1;
    private javax.swing.JButton selectAllButton1;
    // End of variables declaration//GEN-END:variables
    @Override
    public void componentOpened() {
        // TODO add custom code on component opening
    }

    @Override
    public void componentClosed() {
        // TODO add custom code on component closing
    }

    void writeProperties(java.util.Properties p) {
        // better to version settings since initial version as advocated at
        // http://wiki.apidesign.org/wiki/PropertyFiles
        p.setProperty("version", "1.0");
        // TODO store your settings
    }

    void readProperties(java.util.Properties p) {
        String version = p.getProperty("version");
        // TODO read your settings according to their version
    }

    /**
     * Loads model selected in file chooser by user
     */
    public void loadModel() {
        File file = new FileChooserBuilder(ProjectTopComp.class)
                .setTitle("Open human face(s)")
                .setDefaultWorkingDirectory(new File(System.getProperty("user.home")))
                //.setApproveText("Add")
                .setFileFilter(new FileNameExtensionFilter("obj files (*.obj)", "obj"))
                .setAcceptAllFileFilterUsed(true)
                .showOpenDialog();

        if (file == null) {
            System.out.print("No file chosen.");
        } else {
            OutputWindow out = OutputWindow.measureTime();
            String faceId = HumanFaceFactory.instance().loadFace(file);
            HumanFace face = HumanFaceFactory.instance().getFace(faceId);
            out.printDuration("Loaded model " + face.getShortName() +" with " + face.getMeshModel().getNumVertices() + " vertices");

            try {
                // simple hack:
                Path path = Paths.get(file.getAbsolutePath());
                Path folder = path.getParent();
                Path filename = path.getFileName();
                String filestr = filename.toString();
                filestr = filestr.split("_ECA.obj")[0];
                filestr = filestr + "_landmarks.csv";
                face.loadFeaturePoints(folder.toString(), filestr);
            } catch (IOException ex) {
                ex.printStackTrace();
            }

            String name = face.getShortName();
            if (this.project.getFaceByName(name) == null) {
                this.project.addFace(face);
                model.addRow(new Object[]{false, name});
                //createSingleFaceTab(face, name);
            } else {
                JOptionPane.showMessageDialog(this, "Model with this name is already loaded");
            }
        }
    }

    /**
     * Load two models for 1:1 comparison
     
    public void loadTwoModels() {
        
        File file1 = new FileChooserBuilder(ProjectTopComp.class)
                .setTitle("Open human face(s)")
                .setDefaultWorkingDirectory(new File (System.getProperty("user.home")))
                //.setApproveText("Add")
                .setFileFilter(new FileNameExtensionFilter("obj files (*.obj)", "obj"))
                .setAcceptAllFileFilterUsed(true)
                .showOpenDialog();
        
        File file2 = new FileChooserBuilder(ProjectTopComp.class)
                .setTitle("Open human face(s)")
                .setDefaultWorkingDirectory(new File (System.getProperty("user.home")))
                //.setApproveText("Add")
                .setFileFilter(new FileNameExtensionFilter("obj files (*.obj)", "obj"))
                .setAcceptAllFileFilterUsed(true)
                .showOpenDialog();
        
        if (file1 == null || file2 == null) {
            System.out.print("Missing file.");
        } else {
            String faceId1 = HumanFaceFactory.instance().loadFace(file1);
            String faceId2 = HumanFaceFactory.instance().loadFace(file2);
            HumanFace face1 = HumanFaceFactory.instance().getFace(faceId1);
            HumanFace face2 = HumanFaceFactory.instance().getFace(faceId2);
            
            try {
                // simple hack:
                Path path = Paths.get(file1.getAbsolutePath());
                Path folder = path.getParent();
                Path filename = path.getFileName();
                String filestr = filename.toString();
                filestr = filestr.split("_ECA.obj")[0];
                filestr = filestr + "_landmarks.csv";
                face1.loadFeaturePoints(folder.toString(), filestr);
            } catch(IOException ex) {
                ex.printStackTrace();
            }
            
            try {
                // simple hack:
                Path path = Paths.get(file2.getAbsolutePath());
                Path folder = path.getParent();
                Path filename = path.getFileName();
                String filestr = filename.toString();
                filestr = filestr.split("_ECA.obj")[0];
                filestr = filestr + "_landmarks.csv";
                face2.loadFeaturePoints(folder.toString(), filestr);
            } catch(IOException ex) {
                ex.printStackTrace();
            }
            
            //this.project.setPrimaryFace(face1);
            //this.project.addFace(face1);
            this.project.setFaces(List.of(face1, face2));
            createFaceToFaceTab(face1, face2, "1:1");

        javax.swing.table.DefaultTableModel model = (javax.swing.table.DefaultTableModel) jTable1.getModel();

        if (selectedRows.size() == 2) {

            String name1 = model.getValueAt(selectedRows.get(0), 1).toString();
            String name2 = model.getValueAt(selectedRows.get(1), 1).toString();
            HumanFace face1 = project.getFaceByName(name1);
            HumanFace face2 = project.getFaceByName(name2);
            createFaceToFaceTab(face1, face2, name1 + ":" + name2);
        } else {
            JOptionPane.showMessageDialog(this, "Select two models");
        }
    }*/

   /**
    * Creates and opens tab with one face
    * @param face which will be analyzed
    * @param name name of the tab (name of the model)
    */
    private void createSingleFaceTab(HumanFace face, String name) {
        SingleFaceTab newTab = new SingleFaceTab(face, name);
        this.singleFaceTabs.put(face, newTab);
        newTab.open();
        newTab.requestActive();
    }

    /**
     * Creates and opens tab with two faces (1:1 analysis)
     * @param face1 which will be analyzed
     * @param face2 which will be analyzed
     * @param name name of the tab
     */
    private void createFaceToFaceTab(HumanFace face1, HumanFace face2, String name) {
        FaceToFaceTab newTab = new FaceToFaceTab(face1, face2, name);
        this.faceToFaceTabs.put(face1, newTab);
        this.faceToFaceTabs.put(face2, newTab);
        newTab.open();
        newTab.requestActive();
    }
}
