package cz.fidentis.analyst.visitors.mesh;

import cz.fidentis.analyst.mesh.core.MeshModel;
import cz.fidentis.analyst.mesh.io.MeshObjLoader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.vecmath.Vector3d;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

/**
 * @author Radek Oslejsek
 */
public class BoundingBoxVisitorTest {
    
    Path testFileDirectory = Paths.get("src", "test", "resources", "cz", "fidentis", "analyst");
    
    @Test
    void icoSphereTest() throws IOException {
        MeshModel m = MeshObjLoader.read(new File(testFileDirectory.toFile(), "IcoSphere-20.obj"));
        assertNotNull(m);
        BoundingBox visitor = new BoundingBox();
        m.compute(visitor);
        assertEquals(new Vector3d(0.8944249749183655, 1.0, 0.8506399989128113), visitor.getBoundingBox().getMaxPoint());
        assertEquals(new Vector3d(-0.8944249749183655, -1.0, -0.8506399989128113), visitor.getBoundingBox().getMinPoint());
    }
    
    @Test
    void combinedTest() throws IOException {
        MeshModel m = MeshObjLoader.read(new File(testFileDirectory.toFile(), "IcoSphere-20.obj"));
        assertNotNull(m);
        BoundingBox visitor = new BoundingBox();
        m.compute(visitor);
        
        m = MeshObjLoader.read(new File(testFileDirectory.toFile(), "Tetrahedron.obj"));
        assertNotNull(m);
        m.compute(visitor);
        
        assertEquals(new Vector3d(1.0, 1.0, 1.0), visitor.getBoundingBox().getMaxPoint());
        assertEquals(new Vector3d(-1.0, -1.0, -1.0), visitor.getBoundingBox().getMinPoint());
    }
}
