package cz.fidentis.analyst.visitors.kdtree;

import cz.fidentis.analyst.kdtree.KdTree;
import cz.fidentis.analyst.mesh.core.CornerTableRow;
import cz.fidentis.analyst.mesh.core.MeshFacet;
import cz.fidentis.analyst.mesh.core.MeshFacetImpl;
import cz.fidentis.analyst.mesh.core.MeshPointImpl;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import static org.junit.jupiter.api.Assertions.assertEquals;
import org.junit.jupiter.api.Test;

public class KdTreeApproxDistToTriTest {
    
    protected MeshFacet getTrivialFacet(double offset, double size) {
        MeshFacet facet = new MeshFacetImpl();
        facet.addVertex(new MeshPointImpl(new Point3d(0, 0, offset), new Vector3d(0, 0, 1), new Vector3d()));
        facet.addVertex(new MeshPointImpl(new Point3d(size, 0, offset), new Vector3d(0, 0, 1), new Vector3d()));
        facet.addVertex(new MeshPointImpl(new Point3d(0, size, offset), new Vector3d(0, 0, 1), new Vector3d()));

        facet.getCornerTable().addRow(new CornerTableRow(0, -1));
        facet.getCornerTable().addRow(new CornerTableRow(1, -1));
        facet.getCornerTable().addRow(new CornerTableRow(2, -1));

        return facet;
    }
    
    protected void distTest(double expectedDist, KdTreeApproxDistanceToTriangles vis) {
        KdTree tree = new KdTree(getTrivialFacet(1.5, 1));
        tree.accept(vis);
        assertEquals(expectedDist, vis.getDistance());
    }
    
    @Test
    public void distTest() {
        KdTreeApproxDistanceToTriangles vis = new KdTreeApproxDistanceToTriangles(new Point3d(0,0,0), false); // sequentially
        distTest(1.5, vis);
    }

    @Test
    public void exactMatchTest() {
        KdTreeApproxDistanceToTriangles vis = new KdTreeApproxDistanceToTriangles(new Point3d(0, 0, 1.5), false); // relative dist, sequentially
        distTest(0, vis);
    }
}
