/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.procrustes;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.face.HumanFaceFactory;
import cz.fidentis.analyst.face.HumanFaceUtils;
import cz.fidentis.analyst.feature.FeaturePoint;
import cz.fidentis.analyst.feature.utils.FileResourcesUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import cz.fidentis.analyst.feature.services.FeaturePointImportService;

/**
 * Class used for debugging
 * 
 * @author Jakub Kolman
 */
public class ProcrustesVisitorTest {

    private static final Path TEST_FILE_DIRECTORY = Paths.get(
            "src", "test", "resources", "cz", "fidentis", "analyst", "comparison", "procrustesAnalysis");

    private static final String HEAD_01 = "0002_01_ECA.obj";
    private static final String HEAD_02 = "0002_02_ECA.obj";
    private static final String FP_HEAD_01 = "0002_01_landmarks.csv";
    private static final String FP_HEAD_02 = "0002_02_landmarks.csv";

/**
 * 
 * @param args
 * @throws IOException
 * @throws ClassNotFoundException
 * @throws Exception 
 */
    public static void main(String[] args) throws IOException, ClassNotFoundException, Exception {
        FileResourcesUtils fru = new FileResourcesUtils();
        HumanFaceFactory factory = new HumanFaceFactory();
//        FeaturePointImportService featurePointImportService = new FeaturePointImportService();

        List<FeaturePoint> fpList01 = FeaturePointImportService.importFeaturePoints(
                TEST_FILE_DIRECTORY.toString(), FP_HEAD_01);
        List<FeaturePoint> fpList02 = FeaturePointImportService.importFeaturePoints(
                TEST_FILE_DIRECTORY.toString(), FP_HEAD_02);
        HumanFace face1 = factory.getFace(factory.loadFace(
                fru.getFile(TEST_FILE_DIRECTORY.toString(), HEAD_01)));
        HumanFace face2 = factory.getFace(factory.loadFace(
                fru.getFile(TEST_FILE_DIRECTORY.toString(), HEAD_02)));

        face1.setFeaturePoints(fpList01);
        face2.setFeaturePoints(fpList02);

        tryProcrustesVisitor(face1, face2);

    }

    protected static void tryProcrustesVisitor(HumanFace face1, HumanFace face2) {
        HumanFaceUtils.alignFeaturePoints(face1, face2, false, false);
        HumanFaceUtils.alignFeaturePoints(face1, face2, true, false);
    }

}
