/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.fidentis.analyst.procrustes;

import cz.fidentis.analyst.face.HumanFace;
import cz.fidentis.analyst.face.HumanFaceFactory;
import cz.fidentis.analyst.feature.FeaturePoint;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertTrue;

import cz.fidentis.analyst.feature.utils.FileResourcesUtils;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import cz.fidentis.analyst.feature.services.FeaturePointCsvLoader;

import java.io.IOException;

/**
 *
 * @author Jakub Kolman
 */
public class ProcrustesAnalysisFaceModelTest {

    private static final Path TEST_FILE_DIRECTORY = Paths.get(
            "src", "test", "resources", "cz", "fidentis", "analyst", "comparison", "procrustesAnalysis");
//    src\test\resources\cz\fidentis\analyst\comparison\procrustesAnalysis
    private static final Path FACE_PATH = Paths.get(
            "src", "test", "resources", "cz", "fidentis", "analyst");
    private static final String SORTED_FILE = "landmarksSorted.csv";
    private static final String NOT_SORTED_FILE = "landmarksNotSorted.csv";

    @DisplayName("Test sorting utility sortByFeaturePointType")
    @Test
    void sortByTypeTest() throws IOException {
        FileResourcesUtils fru = new FileResourcesUtils();
        HumanFaceFactory factory = new HumanFaceFactory();
        File file = fru.getFile(FACE_PATH.toString(), "00002_01_ECA.obj");
        String faceId = factory.loadFace(file);
        HumanFace face = factory.getFace(faceId);
        List<FeaturePoint> featurePointsSortedList = FeaturePointCsvLoader.loadFeaturePoints(
                TEST_FILE_DIRECTORY.toString(), SORTED_FILE);
        List<FeaturePoint> featurePointsNotSortedList  = FeaturePointCsvLoader.loadFeaturePoints(
                TEST_FILE_DIRECTORY.toString(), NOT_SORTED_FILE);
        face.setFeaturePoints(featurePointsNotSortedList);
        ProcrustesAnalysisFaceModel faceModel = new ProcrustesAnalysisFaceModel(face);
        List<FeaturePoint> sortedListByType = faceModel.sortListByFeaturePointType(featurePointsNotSortedList);
        assertTrue(featurePointsSortedList != null);
        assertTrue(featurePointsNotSortedList != null);
        assertTrue(featurePointsSortedList.size() > 0);
        assertTrue(featurePointsNotSortedList.size() > 0);
        assertTrue(featurePointsSortedList.equals(sortedListByType));
    }


}
