package cz.fidentis.analyst.mesh.core;

import java.util.List;

/**
 * An ancapsulated mesh plate (with shared vertices).
 *
 * @author Matej Lukes
 */
public interface MeshFacet {
    
    /**
     * returns vertex of specified index
     *
     * @param index index of vertex
     * @return vertex
     */
    MeshPoint getVertex(int index);

    /**
     * adds vertex to MeshFacet
     *
     * @param point new vertex
     */
    void addVertex(MeshPoint point);

    /**
     * returns number of vertices in MeshFacet
     *
     * @return number of vertices
     */
    int getNumberOfVertices();

    /**
     * returns list of vertices in MeshFacet
     *
     * @return list if vertices
     */
    List<MeshPoint> getVertices();

    /**
     * returns Corner Table representing MeshFacet
     *
     * @return corner table
     */
    CornerTable getCornerTable();
    
    /**
     * Returns the mesh as a list of individial triangles.
     * @return the list of individial triangles.
     */
    List<MeshTriangle> asTriangles();
    
    /**
     * Computes and returns bounding box of the mesh facet.
     * @return bounding box of the mesh facet.
     */
    BoundingBox getBoundingBox();
    
    /**
     * Returns true if normals of vertices are calculated.
     * @return true if normals of vertices are calculated.
     */
    boolean hasVertexNormals();
    
    /**
     * Calculates normals of vertices from normals of triangles.
     */
    void calculateVertexNormals();
}
