package cz.fidentis.analyst.dashboard;

import cz.fidentis.analyst.face.HumanFaceListener;
import cz.fidentis.analyst.kdtree.events.KdTreeEvent;
import cz.fidentis.analyst.mesh.events.MeshEvent;
import javax.swing.ImageIcon;
import javax.swing.table.DefaultTableModel;

/**
 * List of faces TableModel
 * 
 * @author Matej Kovar
 */
public class ModelsTableModel extends DefaultTableModel implements HumanFaceListener {
    
    private final ImageIcon notCheck = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "notCheck16x16.png"));
    private final ImageIcon check = new ImageIcon(FaceStatePanel.class.getClassLoader().getResource("/" + "check16x16.png"));
    
    /**
     * Constructor
     * @param columnNames names of Columns
     * @param rowCount number of rows
     */
    public ModelsTableModel(Object[] columnNames, int rowCount) {
        super(columnNames, rowCount);
    }


    private Class[] types = new Class [] {
        java.lang.Boolean.class, java.lang.String.class, ImageIcon.class
    };

    private boolean[] canEdit = new boolean [] {
        true, false, false
    };

    @Override
    public Class getColumnClass(int columnIndex) {
        return types [columnIndex];}

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return canEdit [columnIndex];
    }
    public Class[] getTypes() {
        return types;}

    public void setTypes(Class[] types) {
        this.types = types;}

    public boolean[] getCanEdit() {
        return canEdit;}

    public void setCanEdit(boolean[] canEdit) {
        this.canEdit = canEdit;
    }
    
    /**
     * Adds new row to model
     * @param name String name of the face
     * @param hasKD boolean if face has KD tree calculated
     */
    public void addRowWithName(String name, boolean hasKD) {
        if (hasKD) {
            addRow(new Object[]{false, name, check});
        } else {
            addRow(new Object[]{false, name, notCheck});
        }
    }
    
    /*
     * 
     
    public void sortAlphabeticaly() {
        List<String> rows = new ArrayList();
        for (int i = 0; i < getRowCount(); i++) {
            rows.add(getValueAt(i, 1).toString());
        }
        Collections.sort(rows);
    }
    */
    @Override
    public void kdTreeEvent(KdTreeEvent event) {

        String name = event.getName();
        for (int i = 0; i < getRowCount(); i++) {
            if (getValueAt(i, 1).equals(name)) {
                if (event.isCalculated()) {
                    this.setValueAt(check, i, 2);
                } else {
                    this.setValueAt(notCheck, i, 2);
                }
                
                break;
            }
        }
    }

    @Override
    public void meshEvent(MeshEvent event) {
        //throw new UnsupportedOperationException("Not supported yet."); //To change body of generated methods, choose Tools | Templates.
    }
    
}
