package cz.fidentis.analyst.mesh.io;

import java.io.File;
import javax.swing.filechooser.FileFilter;

/**
 * @author Natalia Bebjakova
 * 
 * Enables to choose just extensions we want in the filechooser 
 */
public class ModelFileFilter extends FileFilter {

    private final String[] extension;
    private final String description;
    
    /**
     * 
     * @param extension Extentions of files
     * @param description Description
     */
    public ModelFileFilter(String[] extension, String description)
    {
        this.extension = extension;
        this.description = description;
    }

    /**
     * 
     * @param f File 
     * @return Whether file has chosen extension or not 
     */
    @Override
    public boolean accept(File f)
    {
        boolean accepted = false;
        for (int i = 0; i< extension.length; i++) {
             if(f.isDirectory() || f.getName().endsWith(extension[i])) {
                accepted = true;
            }
        }
        return accepted;
    }
    
    /**
     * 
     * @return description
     */
    @Override
    public String getDescription() {
        return description;
    }

}