package cz.fidentis.analyst.scene;

import com.jogamp.opengl.GL2;
import cz.fidentis.analyst.mesh.core.MeshRectangleFacet;
import cz.fidentis.analyst.symmetry.Plane;
import cz.fidentis.analyst.visitors.mesh.BoundingBox.BBox;
import javax.vecmath.Point3d;

/**
 * A plane to be shown as a rectangular mesh facet.
 * The rectangular shape is generated at run-time from the associated plane.
 * 
 * @author Radek Oslejsek
 * @author Dominik Racek
 */
public class DrawablePlane extends Drawable {
    
    private Plane plane;
    private final BBox bbox;
    
    
    /**
     * Constructor.
     * 
     * @param plane plane
     * @param bbox bounding box used to estimate cutting pale shape (rectangle)
     */
    public DrawablePlane(Plane plane, BBox bbox) {
        this.plane = plane;
        this.bbox = bbox;
    }

    /**
     * Copy constructor.
     * @param drPlane Original plane
     * @throws NullPointException if the input argument is {@code null}
     */
    public DrawablePlane(DrawablePlane drPlane) {
        super(drPlane);
        this.plane = new Plane(drPlane.getPlane());
        this.bbox = drPlane.bbox;
    }
    
    public Plane getPlane() {
        return plane;
    }
    
    protected void setPlane(Plane plane) {
        this.plane = plane;
    }

    @Override
    protected void renderObject(GL2 gl) {
        renderObject(gl, getPlane().getMesh(bbox));
    }
    
    protected void renderObject(GL2 gl, MeshRectangleFacet facet) {
        gl.glBegin(GL2.GL_TRIANGLES); //vertices are rendered as triangles
        // get the normal and tex coords indicies for face i  
        for (int v = 0; v < facet.getCornerTable().getSize(); v++) {
            Point3d vert = facet.getVertices().get(facet.getCornerTable().getRow(v).getVertexIndex()).getPosition();
            if (v == 0) {
            }
            gl.glVertex3d(vert.x, vert.y, vert.z);
        }
        gl.glEnd();
    }
    
    protected BBox getBBox() {
        return this.bbox;
    }
}
